/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageQuestScreenInit
implements IMessage {
    protected Map<String, List<String>> identifierListsMap;
    protected List<String> identifiersInOrder;

    public MessageQuestScreenInit() {
        this.identifierListsMap = new HashMap<String, List<String>>();
        this.identifiersInOrder = new ArrayList<String>();
    }

    public MessageQuestScreenInit(Map<String, List<String>> mapping, List<String> identifiersInOrder) {
        this.identifierListsMap = mapping;
        this.identifiersInOrder = identifiersInOrder;
    }

    public void fromBytes(ByteBuf buf) {
        this.identifierListsMap.clear();
        buf.retain();
        try (ByteBufInputStream in = new ByteBufInputStream(buf);){
            String listID = null;
            boolean constructNextList = true;
            boolean breakThis = false;
            while (!breakThis) {
                try {
                    String line = in.readUTF();
                    if (constructNextList) {
                        this.identifierListsMap.put(line, new ArrayList());
                        this.identifiersInOrder.add(line);
                        constructNextList = false;
                        listID = line;
                        continue;
                    }
                    if (line.equals(":")) {
                        constructNextList = true;
                        continue;
                    }
                    this.identifierListsMap.get(listID).add(line);
                }
                catch (EOFException eof) {
                    breakThis = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buf.release();
    }

    public void toBytes(ByteBuf buf) {
        try (ByteBufOutputStream out = new ByteBufOutputStream(buf);){
            boolean first = true;
            for (String id : this.identifiersInOrder) {
                if (!first) {
                    out.writeUTF(":");
                }
                first = false;
                out.writeUTF(id);
                for (String string : this.identifierListsMap.get(id)) {
                    out.writeUTF(string);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getIdentifiers() {
        return this.identifiersInOrder;
    }

    public Map<String, List<String>> getIdentifierListMap() {
        return this.identifierListsMap;
    }
}

