/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.QuestVisualInformation;

public class MessageQuestVisual
implements IMessage {
    private static final int[] lengthsPerID = new int[]{12, 14, 14};
    protected int typeID;
    protected String[] strings;

    public MessageQuestVisual() {
        this(0);
    }

    protected MessageQuestVisual(int typeID) {
        this.strings = new String[12];
        this.typeID = typeID;
    }

    public MessageQuestVisual(String[] strings) {
        this(0, strings);
    }

    public <E extends QuestVisualInformation> MessageQuestVisual(String identifier, E visual) {
        String[] stringArray;
        if (visual == null) {
            stringArray = MessageQuestVisual.defaultStringsFor(0, identifier);
        } else {
            String[] stringArray2 = new String[12];
            stringArray2[0] = identifier;
            stringArray2[1] = visual.getName();
            stringArray2[2] = visual.getDescription();
            stringArray2[3] = visual.getClient();
            stringArray2[4] = visual.getAims();
            stringArray2[5] = visual.getFails();
            stringArray2[6] = visual.getAreaID();
            stringArray2[7] = visual.getTimeLimitAsString();
            stringArray2[8] = visual.getType().getAsString();
            stringArray2[9] = visual.getRewardString();
            stringArray2[10] = visual.getFeeString();
            stringArray = stringArray2;
            stringArray2[11] = visual.getMaxPartySize();
        }
        this(stringArray);
    }

    public <E extends QuestRunningInformation> MessageQuestVisual(String identifier, E visual) {
        String[] stringArray;
        if (visual == null) {
            stringArray = MessageQuestVisual.defaultStringsFor(1, identifier);
        } else {
            String[] stringArray2 = new String[14];
            stringArray2[0] = identifier;
            stringArray2[1] = visual.getTrueName();
            stringArray2[2] = visual.getTrueDescription();
            stringArray2[3] = visual.getTrueClient();
            stringArray2[4] = visual.getTrueAims();
            stringArray2[5] = visual.getTrueFails();
            stringArray2[6] = visual.getTrueAreaID();
            stringArray2[7] = visual.getTrueTimeLimitAsString();
            stringArray2[8] = visual.getType().getAsString();
            stringArray2[9] = visual.getTrueRewardString();
            stringArray2[10] = visual.getTrueFeeString();
            stringArray2[11] = visual.getTrueMaxPartySize();
            stringArray2[12] = visual.getTrueShortStatus();
            stringArray = stringArray2;
            stringArray2[13] = visual.getTrueLongStatus();
        }
        this(1, stringArray);
    }

    public void setTypeID(int type) {
        this.typeID = type;
    }

    private static String[] defaultStringsFor(int i, String identifier) {
        String[] ret = null;
        ret = i >= 0 && i < lengthsPerID.length ? new String[lengthsPerID[i]] : new String[12];
        ret[0] = identifier;
        ret[1] = "";
        return ret;
    }

    private MessageQuestVisual(int typeID, String[] strings) {
        this(typeID);
        this.strings = strings;
    }

    public void fromBytes(ByteBuf buf) {
        try (ByteBufInputStream in = new ByteBufInputStream(buf);){
            this.typeID = in.readInt();
            if (this.typeID > 0 && this.typeID < lengthsPerID.length) {
                this.strings = new String[lengthsPerID[this.typeID]];
            }
            for (int i = 0; i < this.strings.length; ++i) {
                this.strings[i] = in.readUTF();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        try (ByteBufOutputStream out = new ByteBufOutputStream(buf);){
            out.writeInt(this.typeID);
            for (int i = 0; i < this.strings.length; ++i) {
                String s = this.strings[i];
                out.writeUTF(s == null ? "" : s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String[] getStrings() {
        return this.strings;
    }

    public int getTypeID() {
        return this.typeID;
    }
}

