/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.EnumSet;
import mhfc.net.common.core.registry.MHFCQuestRegistry;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.packet.MessageQuestVisual;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.QuestSpawnController;
import mhfc.net.common.quests.QuestStatus;
import mhfc.net.common.quests.api.QuestDescription;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.api.QuestGoalSocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class GeneralQuest
implements QuestGoalSocket {
    private QuestDescription originalDescription;
    private QuestRunningInformation visualInformation;
    private PlayerAttributes[] playerAttributes;
    private QuestSpawnController spawnController;
    private int playerCount;
    protected QuestState state;
    protected QuestGoal questGoal;
    protected String areaId;
    protected int reward;
    protected int fee;

    private static PlayerAttributes newAttribute(EntityPlayerMP player) {
        return new PlayerAttributes(player, false, true, false, player.field_70118_ct, player.field_70117_cu, player.field_70116_cv, player.field_70170_p.field_73011_w.field_76574_g);
    }

    public GeneralQuest(QuestGoal goal, int maxPartySize, int reward, int fee, String areaId, QuestDescription originalDescription) {
        this.questGoal = goal;
        goal.setSocket(this);
        this.playerAttributes = new PlayerAttributes[maxPartySize];
        for (int i = 0; i < maxPartySize; ++i) {
            this.playerAttributes[i] = null;
        }
        this.reward = reward;
        this.fee = fee;
        this.areaId = areaId;
        this.state = QuestState.pending;
        this.originalDescription = originalDescription;
        this.visualInformation = new QuestRunningInformation(this);
    }

    public QuestState getState() {
        return this.state;
    }

    public QuestGoal getQuestGoal() {
        return this.questGoal;
    }

    public int getReward() {
        return this.reward;
    }

    public int getFee() {
        return this.fee;
    }

    @Override
    public void questGoalStatusNotification(QuestGoal goal, EnumSet<QuestStatus> newStatus) {
        if (newStatus.contains((Object)QuestStatus.Fulfilled)) {
            this.onSuccess();
        }
        if (newStatus.contains((Object)QuestStatus.Failed)) {
            this.onFail();
        }
        this.updatePlayers();
    }

    protected void onFail() {
        for (int i = 0; i < this.playerCount; ++i) {
            this.playerAttributes[i].player.func_145747_a((IChatComponent)new ChatComponentText("You have failed a quest"));
        }
        this.onEnd();
    }

    protected void onSuccess() {
        for (int i = 0; i < this.playerCount; ++i) {
            this.playerAttributes[i].reward = true;
            this.playerAttributes[i].player.func_82242_a(10);
            this.playerAttributes[i].player.func_145747_a((IChatComponent)new ChatComponentText("You have successfully completed a quest"));
        }
        this.state = QuestState.finished;
        this.onEnd();
    }

    protected void onStart() {
        this.questGoal.setActive(true);
        this.state = QuestState.running;
        this.updatePlayers();
        this.resetVotes();
    }

    private void resetVotes() {
        for (int i = 0; i < this.playerCount; ++i) {
            this.playerAttributes[i].vote = false;
        }
    }

    protected void onEnd() {
        for (int i = 0; i < this.playerCount; ++i) {
            this.removePlayer(i);
        }
        this.visualInformation.cleanUp();
        this.questGoal.questGoalFinalize();
        MHFCQuestRegistry.deregRunningQuest(this);
    }

    protected void updatePlayers() {
        this.visualInformation.updateFromQuest(this);
        for (int i = 0; i < this.playerCount; ++i) {
            EntityPlayerMP p = this.playerAttributes[i].player;
            String id = MHFCQuestRegistry.getIdentifierForQuest(this);
            PacketPipeline.networkPipe.sendTo((IMessage)new MessageQuestVisual(id, this.visualInformation), p);
        }
        MHFCQuestRegistry.questUpdated(this);
    }

    public boolean canJoin(EntityPlayer player) {
        return this.state == QuestState.pending && this.playerCount < this.playerAttributes.length && MHFCQuestRegistry.getQuestForPlayer(player) == null;
    }

    @Override
    public void reset() {
        this.questGoal.reset();
    }

    @Override
    public GeneralQuest getQuest() {
        return this;
    }

    public void addPlayer(EntityPlayer player) {
        if (this.canJoin(player)) {
            this.playerAttributes[this.playerCount] = GeneralQuest.newAttribute((EntityPlayerMP)player);
            ++this.playerCount;
            MHFCQuestRegistry.setQuestForPlayer(player, this);
            this.updatePlayers();
        }
    }

    public boolean removePlayer(EntityPlayer player) {
        int i;
        boolean found = false;
        for (i = 0; i < this.playerAttributes.length; ++i) {
            if (this.playerAttributes[i] == null || player == null || this.playerAttributes[i].player.func_146103_bH().getName() != player.func_146103_bH().getName()) continue;
            found = true;
            break;
        }
        this.removePlayer(i);
        if (this.playerCount == 0) {
            this.onEnd();
        }
        return found;
    }

    protected void removePlayer(int index) {
        if (index < 0 || index >= this.playerCount) {
            return;
        }
        PlayerAttributes att = this.playerAttributes[index];
        PacketPipeline.networkPipe.sendTo((IMessage)new MessageQuestVisual("", null), att.player);
        MHFCQuestRegistry.setQuestForPlayer((EntityPlayer)att.player, null);
        if (att.player.func_130014_f_().field_73011_w.field_76574_g != att.dimensionID) {
            FMLServerHandler.instance().getServer().func_71203_ab().func_72356_a(att.player, att.dimensionID);
        }
        att.player.func_70091_d((double)att.posX, (double)att.posY, (double)att.posZ);
        for (int i = index; i < this.playerCount - 1; ++i) {
            this.playerAttributes[i] = this.playerAttributes[i + 1];
        }
        this.playerAttributes[this.playerCount - 1] = null;
        --this.playerCount;
    }

    public EntityPlayerMP[] getPlayers() {
        EntityPlayerMP[] playrs = new EntityPlayerMP[this.playerCount];
        for (int i = 0; i < this.playerCount; ++i) {
            playrs[i] = this.playerAttributes[i].player;
        }
        return playrs;
    }

    public QuestSpawnController getSpawnController() {
        return this.spawnController;
    }

    public QuestDescription getOriginalDescription() {
        return this.originalDescription;
    }

    public String updateVisual(QuestRunningInformation.InformationType t, String current) {
        if (t == QuestRunningInformation.InformationType.MaxPartySize) {
            return this.playerCount + "/" + this.playerAttributes.length + " {unlocalized:Players}";
        }
        String mod = this.questGoal.modify(t, "");
        if (mod.equals("")) {
            return current;
        }
        return mod;
    }

    public void voteStart(EntityPlayerMP player) {
        boolean start;
        for (int i = 0; i < this.playerCount; ++i) {
            if (this.playerAttributes[i].player != player) continue;
            this.playerAttributes[i].vote = true;
            break;
        }
        if (start = this.allVotes()) {
            this.onStart();
        }
    }

    private boolean allVotes() {
        boolean votes = true;
        for (int i = 0; i < this.playerCount; ++i) {
            votes &= this.playerAttributes[i] == null || this.playerAttributes[i].vote;
        }
        return votes;
    }

    public void voteEnd(EntityPlayerMP player) {
        boolean end;
        for (int i = 0; i < this.playerCount; ++i) {
            if (this.playerAttributes[i].player != player) continue;
            this.playerAttributes[i].vote = false;
            break;
        }
        if ((end = this.allVotes()) && this.state == QuestState.running) {
            this.onEnd();
        }
    }

    public QuestRunningInformation getRunningInformation() {
        return this.visualInformation;
    }

    private static class PlayerAttributes {
        public EntityPlayerMP player;
        public boolean vote;
        public boolean restoreInventory;
        public boolean reward;
        public int posX;
        public int posY;
        public int posZ;
        public int dimensionID;

        public PlayerAttributes(EntityPlayerMP p, boolean vote, boolean restoreInventory, boolean reward, int x, int y, int z, int dim) {
            this.player = p;
            this.restoreInventory = restoreInventory;
            this.vote = vote;
            this.reward = reward;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.dimensionID = dim;
        }
    }

    static enum QuestState {
        pending,
        running,
        finished,
        resigned;

    }
}

