/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests;

import java.util.List;
import mhfc.net.common.quests.GeneralQuest;
import mhfc.net.common.quests.QuestVisualInformation;
import mhfc.net.common.util.MHFCStringDecode;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.StatCollector;

public class QuestRunningInformation
extends QuestVisualInformation {
    protected String shortStatus;
    protected String longStatus;
    protected MHFCStringDecode.CompositeString nameElements;
    protected MHFCStringDecode.CompositeString descriptionElements;
    protected MHFCStringDecode.CompositeString clientElements;
    protected MHFCStringDecode.CompositeString aimsElements;
    protected MHFCStringDecode.CompositeString failsElements;
    protected MHFCStringDecode.CompositeString areaNameIdElements;
    protected MHFCStringDecode.CompositeString timeLimitInSElements;
    protected MHFCStringDecode.CompositeString rewardElements;
    protected MHFCStringDecode.CompositeString feeElements;
    protected MHFCStringDecode.CompositeString maxPartySizeElements;
    protected MHFCStringDecode.CompositeString shortStatusElements;
    protected MHFCStringDecode.CompositeString longStatusElements;

    public QuestRunningInformation(GeneralQuest quest) {
        super(quest.getOriginalDescription().getVisualInformation());
        String localStatusShort = "";
        String localStatusLong = "";
        this.shortStatus = localStatusShort;
        this.longStatus = localStatusLong;
        this.updateFromQuest(quest);
    }

    public QuestRunningInformation(QuestVisualInformation information, String shortStatus, String longStatus) {
        super(information);
        this.shortStatus = shortStatus;
        this.longStatus = longStatus;
        this.breakAll();
    }

    protected void remove(List<MHFCStringDecode.StringElement> elements) {
        if (elements == null) {
            return;
        }
        for (MHFCStringDecode.StringElement e : elements) {
            e.remove();
        }
    }

    public void updateFromQuest(GeneralQuest q) {
        this.cleanUp();
        this.name = q.updateVisual(InformationType.Name, this.name);
        this.description = q.updateVisual(InformationType.Description, this.description);
        this.client = q.updateVisual(InformationType.Client, this.client);
        this.aims = q.updateVisual(InformationType.Aims, this.aims);
        this.fails = q.updateVisual(InformationType.Fails, this.fails);
        this.areaNameId = q.updateVisual(InformationType.AreaNameID, this.areaNameId);
        this.timeLimitInS = q.updateVisual(InformationType.TimeLimit, this.timeLimitInS);
        this.reward = q.updateVisual(InformationType.Reward, this.reward);
        this.fee = q.updateVisual(InformationType.Fee, this.fee);
        this.maxPartySize = q.updateVisual(InformationType.MaxPartySize, this.maxPartySize);
        this.shortStatus = q.updateVisual(InformationType.ShortStatus, this.shortStatus);
        this.longStatus = q.updateVisual(InformationType.LongStatus, this.longStatus);
        this.breakAll();
    }

    private void breakAll() {
        this.nameElements = new MHFCStringDecode.CompositeString(this.name);
        this.descriptionElements = new MHFCStringDecode.CompositeString(this.description);
        this.clientElements = new MHFCStringDecode.CompositeString(this.client);
        this.aimsElements = new MHFCStringDecode.CompositeString(this.aims);
        this.failsElements = new MHFCStringDecode.CompositeString(this.fails);
        this.areaNameIdElements = new MHFCStringDecode.CompositeString(this.areaNameId);
        this.timeLimitInSElements = new MHFCStringDecode.CompositeString(this.timeLimitInS);
        this.rewardElements = new MHFCStringDecode.CompositeString(this.reward);
        this.feeElements = new MHFCStringDecode.CompositeString(this.fee);
        this.maxPartySizeElements = new MHFCStringDecode.CompositeString(this.maxPartySize);
        this.shortStatusElements = new MHFCStringDecode.CompositeString(this.shortStatus);
        this.longStatusElements = new MHFCStringDecode.CompositeString(this.longStatus);
    }

    public String getShortStatus() {
        return this.shortStatusElements.stringValue();
    }

    public String getTrueShortStatus() {
        return this.shortStatus;
    }

    public String getLongStatus() {
        return this.longStatusElements.stringValue();
    }

    public String getTrueLongStatus() {
        return this.longStatus;
    }

    @Override
    public String getName() {
        return this.nameElements.stringValue();
    }

    public String getTrueName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.descriptionElements.stringValue();
    }

    public String getTrueDescription() {
        return this.description;
    }

    @Override
    public String getClient() {
        return this.clientElements.stringValue();
    }

    public String getTrueClient() {
        return this.client;
    }

    @Override
    public String getAims() {
        return this.aimsElements.stringValue();
    }

    public String getTrueAims() {
        return this.aims;
    }

    @Override
    public String getFails() {
        return this.failsElements.stringValue();
    }

    public String getTrueFails() {
        return this.fails;
    }

    @Override
    public String getTimeLimitAsString() {
        return this.timeLimitInSElements.stringValue();
    }

    public String getTrueTimeLimitAsString() {
        return this.timeLimitInS;
    }

    @Override
    public String getRewardString() {
        return this.rewardElements.stringValue();
    }

    public String getTrueRewardString() {
        return this.reward;
    }

    @Override
    public String getFeeString() {
        return this.feeElements.stringValue();
    }

    public String getTrueFeeString() {
        return this.fee;
    }

    @Override
    public String getAreaID() {
        return this.areaNameIdElements.stringValue();
    }

    public String getTrueAreaID() {
        return this.areaNameId;
    }

    @Override
    public String getMaxPartySize() {
        return this.maxPartySizeElements.stringValue();
    }

    public String getTrueMaxPartySize() {
        return this.maxPartySize;
    }

    @Override
    public void drawInformation(int positionX, int positionY, int width, int height, int page, FontRenderer fontRenderer) {
        width = Math.max(width, 20);
        int currentY = this.drawHead(positionX, positionY, width, fontRenderer);
        switch (page) {
            case 0: {
                currentY = this.drawBaseInformation(positionX, currentY, width, fontRenderer);
                String TAG_STATUS = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.statuslong");
                currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, TAG_STATUS, positionX + 5, currentY, 0, 14193980);
                currentY += 2;
                String draw = this.getLongStatus();
                for (String line : draw.split("\n")) {
                    currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, line, positionX + width / 8, currentY, 7 * width / 8 - 5, 0x404040);
                    currentY += 2;
                }
                break;
            }
            case 1: {
                this.drawAimsFails(positionX, positionY, width, height, currentY, fontRenderer);
                break;
            }
            case 2: {
                this.drawClientDescription(positionX, currentY, width, fontRenderer);
            }
        }
        String draw = page + 1 + "/3";
        fontRenderer.func_78276_b(draw, positionX + width - fontRenderer.func_78256_a(draw) - 5, positionY + height - fontRenderer.field_78288_b - 5, 0x404040);
    }

    public void cleanUp() {
        if (this.nameElements != null) {
            this.nameElements.remove();
        }
        if (this.descriptionElements != null) {
            this.descriptionElements.remove();
        }
        if (this.clientElements != null) {
            this.clientElements.remove();
        }
        if (this.aimsElements != null) {
            this.aimsElements.remove();
        }
        if (this.failsElements != null) {
            this.failsElements.remove();
        }
        if (this.areaNameIdElements != null) {
            this.areaNameIdElements.remove();
        }
        if (this.timeLimitInSElements != null) {
            this.timeLimitInSElements.remove();
        }
        if (this.rewardElements != null) {
            this.rewardElements.remove();
        }
        if (this.feeElements != null) {
            this.feeElements.remove();
        }
        if (this.maxPartySizeElements != null) {
            this.maxPartySizeElements.remove();
        }
        if (this.shortStatusElements != null) {
            this.shortStatusElements.remove();
        }
        if (this.longStatusElements != null) {
            this.longStatusElements.remove();
        }
    }

    public static enum InformationType {
        Name,
        Description,
        Client,
        Aims,
        Fails,
        AreaNameID,
        TimeLimit,
        Reward,
        Fee,
        MaxPartySize,
        ShortStatus,
        LongStatus;

    }
}

