/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests;

import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.StatCollector;

public class QuestVisualInformation {
    public static final int BORDER = 5;
    public static final int LINE_SEPERATION = 2;
    public static final int COLOUR_HEADER = 14193980;
    public static final int COLOUR_TEXT = 0x404040;
    public static final int COLOUR_TITLE = 0;
    public static final QuestVisualInformation LOADING_REPLACEMENT = new QuestVisualInformation("Loading...", "Waiting for server response", "Guild hunter", "---", "----", "Town", "No time limit", "A quest", "None", "---", QuestType.EpicHunting);
    public static final QuestVisualInformation IDENTIFIER_ERROR = new QuestVisualInformation("Identifier invalid", "Please contact the server operator so he can give information to the mod team", "MHFC mod team", "Work out this issue", "Not contacting anyone", "Network or server", "Just do it asap", "A better experience", "A few seconds of your time", "Hopefully one", QuestType.Gathering);
    protected String name;
    protected String description;
    protected String client;
    protected String aims;
    protected String fails;
    protected String areaNameId;
    protected String timeLimitInS;
    protected QuestType type;
    protected String reward;
    protected String fee;
    protected String maxPartySize;

    protected QuestVisualInformation(QuestVisualInformation copy) {
        if (copy == null) {
            return;
        }
        this.name = copy.getName();
        this.description = copy.getDescription();
        this.client = copy.getClient();
        this.aims = copy.getAims();
        this.fails = copy.getFails();
        this.areaNameId = copy.getAreaID();
        this.timeLimitInS = copy.getTimeLimitAsString();
        this.type = copy.getType();
        this.reward = copy.getRewardString();
        this.fee = copy.getFeeString();
        this.maxPartySize = copy.getMaxPartySize();
    }

    public QuestVisualInformation(String name, String description, String client, String aims, String fails, String areaNameID, String timeLimitInS, String reward, String fee, String maxPartySize, QuestType type) {
        this.name = name;
        this.type = type;
        this.timeLimitInS = timeLimitInS;
        this.description = description;
        this.client = client;
        this.aims = aims;
        this.fails = fails;
        this.reward = reward;
        this.fee = fee;
        this.maxPartySize = maxPartySize;
        this.areaNameId = areaNameID;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClient() {
        return this.client;
    }

    public String getAims() {
        return this.aims;
    }

    public String getFails() {
        return this.fails;
    }

    public String getTimeLimitAsString() {
        return this.timeLimitInS;
    }

    public QuestType getType() {
        return this.type;
    }

    public String getRewardString() {
        return this.reward;
    }

    public String getFeeString() {
        return this.fee;
    }

    public String getAreaID() {
        return this.areaNameId;
    }

    public String getMaxPartySize() {
        return this.maxPartySize;
    }

    public void drawInformation(int positionX, int positionY, int width, int height, FontRenderer fontRenderer, int renderFrame) {
        int FPS = 120;
        this.drawInformation(positionX, positionY, width, height, Math.max(renderFrame / FPS % 4 - 1, 0), fontRenderer);
    }

    public void drawInformation(int positionX, int positionY, int width, int height, int page, FontRenderer fontRenderer) {
        String TAG_MONSTERS = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.monsters");
        String TAG_REQUISITES = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.requisites");
        int lineHeight = fontRenderer.field_78288_b + 2;
        int currentY = this.drawHead(positionX, positionY, width, fontRenderer);
        switch (page) {
            case 0: {
                currentY = this.drawBaseInformation(positionX, currentY, width, fontRenderer);
                currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, TAG_MONSTERS, positionX + 5, currentY, 0, 14193980);
                currentY += 2;
                currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, "NYI", positionX + width / 8, currentY, 7 * width / 8 - 5, 0x404040);
                currentY += 2;
                currentY = Math.max(currentY, positionY + height / 2);
                currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, TAG_REQUISITES, positionX + 5, currentY, 0, 14193980);
                fontRenderer.func_78279_b("NYI", positionX + width / 8, currentY += 2, 7 * width / 8 - 5, 0x404040);
                break;
            }
            case 1: {
                this.drawAimsFails(positionX, positionY, width, height, currentY, fontRenderer);
                break;
            }
            case 2: {
                this.drawClientDescription(positionX, currentY, width, fontRenderer);
            }
        }
        String draw = page + 1 + "/3";
        fontRenderer.func_78276_b(draw, positionX + width - fontRenderer.func_78256_a(draw) - 4, positionY + height - lineHeight, 0x404040);
    }

    protected void drawClientDescription(int positionX, int currentY, int width, FontRenderer fontRenderer) {
        width = Math.max(width, 20);
        String TAG_CLIENT = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.client");
        String TAG_DESCRIPTION = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.description");
        fontRenderer.func_78276_b(TAG_CLIENT, positionX + 5, currentY, 14193980);
        int offsetX = 5 + fontRenderer.func_78256_a(TAG_CLIENT) + 5;
        int drawWidth = width - offsetX - 5;
        String client = this.getClient();
        if (MHFCGuiUtil.isDrawWidthTooSmall(fontRenderer, drawWidth, client)) {
            currentY += fontRenderer.field_78288_b;
            offsetX = width / 8;
            drawWidth = width - offsetX - 5;
        }
        currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, this.getClient(), positionX + offsetX, currentY, width + offsetX - 5, 0x404040);
        currentY += 2;
        currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, TAG_DESCRIPTION, positionX + 5, currentY, 0, 14193980);
        fontRenderer.func_78279_b(this.getDescription(), positionX + width / 8, currentY += 2, 7 * width / 8 - 5, 0x404040);
    }

    protected void drawAimsFails(int positionX, int positionY, int width, int height, int currentY, FontRenderer fontRenderer) {
        String TAG_AIMS = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.aims");
        String TAG_FAILS = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.fails");
        currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, TAG_AIMS, positionX + 5, currentY, 0, 14193980);
        currentY += 2;
        currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, this.getAims(), positionX + width / 8, currentY, 7 * width / 8 - 5, 0x404040);
        currentY += 2;
        currentY = Math.max(currentY, positionY + height / 2);
        currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, TAG_FAILS, positionX + 5, currentY, 0, 14193980);
        currentY += 2;
        currentY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, this.getFails(), positionX + width / 8, currentY, 7 * width / 8 - 5, 0x404040);
        currentY += 2;
    }

    protected int drawHead(int positionX, int positionY, int width, FontRenderer fontRenderer) {
        String TAG_TYPE = StatCollector.func_74838_a((String)this.getType().getAsString());
        positionY += 5;
        positionY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, TAG_TYPE, positionX + (width - fontRenderer.func_78256_a(TAG_TYPE)) / 2, positionY, 0, 0);
        positionY += 2;
        String draw = this.getName();
        positionY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, this.getName(), positionX + (width - fontRenderer.func_78256_a(draw)) / 2, positionY, 0, 0);
        return positionY += 2;
    }

    protected int drawBaseInformation(int positionX, int positionY, int width, FontRenderer fontRenderer) {
        String TAG_FEE = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.fee");
        String TAG_REWARD = StatCollector.func_74838_a((String)"mfhc.quests.visual.tag.reward");
        String TAG_TIME = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.time");
        String TAG_AREA = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.area");
        String AREA_ID = StatCollector.func_74838_a((String)this.getAreaID());
        fontRenderer.func_78276_b(TAG_REWARD, positionX + 5, positionY, 14193980);
        positionY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, this.getRewardString(), positionX + width / 2, positionY, width / 2 - 5, 0x404040);
        fontRenderer.func_78276_b(TAG_FEE, positionX + 5, positionY += 2, 14193980);
        positionY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, this.getFeeString(), positionX + width / 2, positionY, width / 2 - 5, 0x404040);
        fontRenderer.func_78276_b(TAG_TIME, positionX + 5, positionY += 2, 14193980);
        positionY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, this.getTimeLimitAsString(), positionX + width / 2, positionY, width / 2 - 5, 0x404040);
        fontRenderer.func_78276_b(TAG_AREA, positionX + 5, positionY += 2, 14193980);
        positionY += MHFCGuiUtil.drawTextAndReturnHeight(fontRenderer, AREA_ID, positionX + width / 2, positionY, width / 2 - 5, 0x404040);
        return positionY += 2;
    }

    public static enum QuestType {
        Hunting("mhfc.quests.type.hunting"),
        EpicHunting("mhfc.quests.type.epichunting"),
        Killing("mhfc.quests.type.killing"),
        Gathering("mhfc.quests.type.gathering");

        String s;

        private QuestType(String s) {
            this.s = s;
        }

        public String getAsString() {
            return this.s;
        }
    }
}

