/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.api;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import mhfc.net.common.core.registry.MHFCQuestBuildRegistry;
import mhfc.net.common.quests.api.GoalDescription;
import net.minecraft.util.JsonUtils;

public class GoalReference {
    boolean referByString;
    String id;
    GoalDescription description;

    public static GoalReference constructFromJson(JsonElement element, JsonDeserializationContext context) {
        if (element == null) {
            return new GoalReference((GoalDescription)null);
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return new GoalReference(JsonUtils.func_151206_a((JsonElement)element, (String)"Goal Reference"));
        }
        if (element.isJsonObject()) {
            GoalDescription desc = (GoalDescription)context.deserialize(element, GoalDescription.class);
            return new GoalReference(desc);
        }
        throw new JsonParseException("Required a reference on a goal but found something else");
    }

    public GoalReference(String id) {
        this.id = id;
        this.referByString = true;
        this.description = null;
    }

    public GoalReference(GoalDescription description) {
        this.description = description;
        this.referByString = false;
        this.id = null;
    }

    public GoalDescription getReferredDescription() {
        if (this.referByString) {
            return MHFCQuestBuildRegistry.getGoalDescription(this.id);
        }
        return this.description;
    }

    public static class GoalRefSerializer
    implements JsonDeserializer<GoalReference> {
        public GoalReference deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return GoalReference.constructFromJson(json, context);
        }
    }
}

