/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mhfc.net.MHFCMain;
import mhfc.net.common.core.registry.MHFCQuestBuildRegistry;
import mhfc.net.common.core.registry.MHFCQuestRegistry;
import mhfc.net.common.quests.GeneralQuest;
import mhfc.net.common.quests.api.GoalDescription;
import mhfc.net.common.quests.api.IGoalFactory;
import mhfc.net.common.quests.api.IQuestFactory;
import mhfc.net.common.quests.api.QuestDescription;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.factory.ChainGoalFactory;
import mhfc.net.common.quests.factory.DeathRestrictionGoalFactory;
import mhfc.net.common.quests.factory.DefaultQuestFactory;
import mhfc.net.common.quests.factory.ForkGoalFactory;
import mhfc.net.common.quests.factory.HuntingGoalFactory;
import mhfc.net.common.quests.factory.TimeGoalFactory;
import net.minecraft.entity.player.EntityPlayer;

public class QuestFactory {
    private static Map<String, IQuestFactory> questFactoryMap = new HashMap<String, IQuestFactory>();
    private static Map<String, IGoalFactory> goalFactoryMap = new HashMap<String, IGoalFactory>();

    public static QuestDescription getQuestDescription(String id) {
        QuestDescription qd = MHFCQuestBuildRegistry.getQuestDescription(id);
        return qd;
    }

    public static GoalDescription getGoalDescription(String id) {
        GoalDescription gd = MHFCQuestBuildRegistry.getGoalDescription(id);
        return gd;
    }

    public static boolean insertQuestFactory(String str, IQuestFactory fact) {
        if (questFactoryMap.containsKey(str)) {
            return false;
        }
        questFactoryMap.put(str, fact);
        return true;
    }

    public static boolean insertGoalFactory(String str, IGoalFactory fact) {
        if (goalFactoryMap.containsKey(str)) {
            return false;
        }
        goalFactoryMap.put(str, fact);
        return true;
    }

    public static GeneralQuest constructQuest(QuestDescription qd, EntityPlayer initiator, String assignedID) {
        if (qd == null || !questFactoryMap.containsKey(qd.getFactory())) {
            return null;
        }
        IQuestFactory factory = QuestFactory.getQuestFactory(qd.getFactory());
        if (factory == null) {
            return null;
        }
        GeneralQuest quest = factory.buildQuest(qd);
        if (quest == null) {
            return null;
        }
        if (quest.canJoin(initiator)) {
            MHFCQuestRegistry.regRunningQuest(quest, assignedID);
            quest.addPlayer(initiator);
            return quest;
        }
        quest.getQuestGoal().questGoalFinalize();
        return null;
    }

    public static IQuestFactory getQuestFactory(String type) {
        return questFactoryMap.get(type);
    }

    public static QuestGoal constructGoal(GoalDescription gd) {
        Objects.requireNonNull(gd, "Goal description was null");
        QuestGoal goal = gd.build();
        if (goal == null) {
            MHFCMain.logger.warn("Constructed goal returned as null");
        }
        return goal;
    }

    public static IGoalFactory getGoalFactory(String type) {
        return goalFactoryMap.get(type);
    }

    static {
        QuestFactory.insertQuestFactory("", new DefaultQuestFactory());
        DeathRestrictionGoalFactory drFactory = new DeathRestrictionGoalFactory();
        QuestFactory.insertGoalFactory("death", drFactory);
        QuestFactory.insertGoalFactory("death restriction", drFactory);
        TimeGoalFactory tFactory = new TimeGoalFactory();
        QuestFactory.insertGoalFactory("time", tFactory);
        QuestFactory.insertGoalFactory("hunting", new HuntingGoalFactory());
        QuestFactory.insertGoalFactory("timer", tFactory);
        QuestFactory.insertGoalFactory("chain", new ChainGoalFactory());
        QuestFactory.insertGoalFactory("fork", new ForkGoalFactory());
    }
}

