/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.api;

import java.util.EnumSet;
import mhfc.net.common.quests.GeneralQuest;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.QuestStatus;
import mhfc.net.common.quests.api.QuestGoalSocket;

public abstract class QuestGoal {
    protected QuestGoalSocket socket;

    public QuestGoal() {
        this(null);
    }

    public QuestGoal(QuestGoalSocket parent) {
        this.socket = parent;
    }

    public QuestGoalSocket getSocket() {
        return this.socket;
    }

    public void setSocket(QuestGoalSocket socket) {
        this.socket = socket;
    }

    public abstract boolean isFulfilled();

    public abstract boolean isFailed();

    public abstract void reset();

    public abstract void setActive(boolean var1);

    public void questGoalFinalize() {
    }

    public GeneralQuest getQuest() {
        if (this.socket == null) {
            return null;
        }
        return this.socket.getQuest();
    }

    protected void notifyOfStatus(EnumSet<QuestStatus> newStatus) {
        if (this.socket == null) {
            return;
        }
        this.socket.questGoalStatusNotification(this, newStatus);
    }

    protected void notifyOfStatus(boolean newFulfilled, boolean newFailed) {
        EnumSet<QuestStatus> e = EnumSet.noneOf(QuestStatus.class);
        if (newFulfilled) {
            e.add(QuestStatus.Fulfilled);
        }
        if (newFailed) {
            e.add(QuestStatus.Failed);
        }
        this.notifyOfStatus(e);
    }

    public abstract String modify(QuestRunningInformation.InformationType var1, String var2);
}

