/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.descriptions;

import mhfc.net.MHFCMain;
import mhfc.net.common.quests.api.GoalDescription;
import mhfc.net.common.quests.api.GoalReference;
import mhfc.net.common.quests.api.QuestFactory;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.goals.ChainQuestGoal;

public class ChainGoalDescription
extends GoalDescription {
    public static final String ID_GOAL = "goal";
    public static final String ID_SUCCESSOR = "successor";
    GoalReference trueGoal;
    GoalReference successorGoal;

    public ChainGoalDescription(GoalReference trueGoal, GoalReference successorGoal) {
        super("chain");
        this.trueGoal = trueGoal;
        this.successorGoal = successorGoal;
    }

    public GoalDescription getTrueGoal() {
        return this.trueGoal.getReferredDescription();
    }

    public GoalDescription getSuccessorGoal() {
        return this.successorGoal.getReferredDescription();
    }

    @Override
    public QuestGoal build() {
        QuestGoal dep1;
        GoalDescription truG = this.getTrueGoal();
        GoalDescription sucG = this.getSuccessorGoal();
        QuestGoal dep2 = sucG == null ? null : QuestFactory.constructGoal(sucG);
        boolean trueGoalNull = false;
        if (truG == null) {
            trueGoalNull = true;
            dep1 = null;
        } else {
            dep1 = QuestFactory.constructGoal(truG);
        }
        if (trueGoalNull |= dep1 == null) {
            MHFCMain.logger.warn("A chain goal used an invalid description as its goal. Using the successor goal instead of the chain goal");
            return dep2;
        }
        ChainQuestGoal goal = new ChainQuestGoal(dep1, dep2);
        dep1.setSocket(goal);
        if (dep2 != null) {
            dep2.setSocket(goal);
        }
        return goal;
    }
}

