/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.descriptions;

import java.util.ArrayList;
import java.util.List;
import mhfc.net.common.quests.api.GoalDescription;
import mhfc.net.common.quests.api.GoalReference;
import mhfc.net.common.quests.api.QuestFactory;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.goals.ForkQuestGoal;

public class ForkGoalDescription
extends GoalDescription {
    public static final String ID_REQUIRED = "requisites";
    public static final String ID_OPTIONAL = "optional";
    private GoalReference[] required;
    private GoalReference[] optional;

    public ForkGoalDescription(GoalReference[] required, GoalReference[] optional) {
        super("fork");
        this.required = required;
        this.optional = optional;
    }

    public List<GoalDescription> getRequired() {
        ArrayList<GoalDescription> list = new ArrayList<GoalDescription>();
        if (this.required == null) {
            return list;
        }
        for (int i = 0; i < this.required.length; ++i) {
            list.add(this.required[i].getReferredDescription());
        }
        return list;
    }

    public List<GoalDescription> getOptional() {
        ArrayList<GoalDescription> list = new ArrayList<GoalDescription>();
        if (this.optional == null) {
            return list;
        }
        for (int i = 0; i < this.optional.length; ++i) {
            list.add(this.optional[i].getReferredDescription());
        }
        return list;
    }

    @Override
    public ForkQuestGoal build() {
        QuestGoal q;
        List<GoalDescription> required = this.getRequired();
        List<GoalDescription> optional = this.getOptional();
        ForkQuestGoal fork = new ForkQuestGoal(null);
        for (GoalDescription desc : required) {
            q = QuestFactory.constructGoal(desc);
            if (q == null) continue;
            fork.addRequisite(q);
        }
        for (GoalDescription desc : optional) {
            q = QuestFactory.constructGoal(desc);
            if (q == null) continue;
            fork.addOptional(q);
        }
        return fork;
    }
}

