/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.factory;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mhfc.net.common.quests.api.GoalDescription;
import mhfc.net.common.quests.api.GoalReference;
import mhfc.net.common.quests.api.IGoalFactory;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.descriptions.ChainGoalDescription;

public class ChainGoalFactory
implements IGoalFactory {
    @Override
    public QuestGoal buildQuestGoal(GoalDescription gd) {
        return gd.build();
    }

    @Override
    public GoalDescription buildGoalDescription(JsonObject json, JsonDeserializationContext context) {
        if (!json.has("goal")) {
            throw new JsonParseException("A chain goal requires field goal");
        }
        GoalReference goal = GoalReference.constructFromJson(json.get("goal"), context);
        GoalReference successor = GoalReference.constructFromJson(json.get("successor"), context);
        return new ChainGoalDescription(goal, successor);
    }
}

