/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.factory;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mhfc.net.common.quests.api.GoalDescription;
import mhfc.net.common.quests.api.IGoalFactory;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.descriptions.HuntingGoalDescription;
import net.minecraft.entity.EntityList;
import net.minecraft.util.JsonUtils;

public class HuntingGoalFactory
implements IGoalFactory {
    @Override
    public QuestGoal buildQuestGoal(GoalDescription gd) {
        return gd.build();
    }

    @Override
    public GoalDescription buildGoalDescription(JsonObject json, JsonDeserializationContext context) {
        if (!json.has("target") || !json.has("amount")) {
            throw new JsonParseException("A hunting goal needs a target and a amountattribute");
        }
        String mobID = JsonUtils.func_151206_a((JsonElement)json.get("target"), (String)"target");
        Class goalClass = (Class)EntityList.field_75625_b.get(mobID);
        if (goalClass == null) {
            throw new JsonParseException("The mob identifier " + mobID + " could not be resolved");
        }
        if (!json.get("amount").isJsonPrimitive()) {
            throw new JsonParseException("The amount given is not of type integer");
        }
        int amount = json.get("amount").getAsInt();
        return new HuntingGoalDescription(goalClass, amount);
    }
}

