/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.goals;

import java.util.EnumSet;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.QuestStatus;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.api.QuestGoalSocket;

public class ChainQuestGoal
extends QuestGoal
implements QuestGoalSocket {
    protected QuestGoal thisGoal;
    protected QuestGoal next;
    private boolean finalFailed;

    public ChainQuestGoal(QuestGoalSocket socket, QuestGoal thisGoal, QuestGoal next) {
        super(socket);
        if (thisGoal == null) {
            throw new IllegalArgumentException("ChainQuestGoal: The goal of this step may not be null");
        }
        thisGoal.setSocket(this);
        this.thisGoal = thisGoal;
        this.next = next;
        if (next != null) {
            next.setSocket(this);
        }
        this.finalFailed = false;
    }

    public ChainQuestGoal(QuestGoal thisGoal, QuestGoal next) {
        this(null, thisGoal, next);
    }

    public ChainQuestGoal(QuestGoal thisGoal) {
        this(null, thisGoal, null);
    }

    @Override
    public boolean isFulfilled() {
        return this.thisGoal == null;
    }

    @Override
    public boolean isFailed() {
        if (this.thisGoal == null) {
            return this.finalFailed;
        }
        return this.thisGoal.isFailed();
    }

    @Override
    public void questGoalStatusNotification(QuestGoal caller, EnumSet<QuestStatus> newStatus) {
        if (caller == this.thisGoal) {
            if (newStatus.contains((Object)QuestStatus.Fulfilled)) {
                this.onFulfilled(newStatus.contains((Object)QuestStatus.Failed));
            }
            if (newStatus.contains((Object)QuestStatus.Failed)) {
                this.onFailed(newStatus.contains((Object)QuestStatus.Fulfilled));
            }
        } else if (caller == this.next) {
            this.onNextNotified(newStatus);
        } else {
            this.onUnknownStatusNotification(caller, newStatus);
        }
    }

    @Override
    public void questGoalFinalize() {
        if (this.thisGoal != null) {
            this.thisGoal.questGoalFinalize();
        }
        if (this.next != null) {
            this.next.questGoalFinalize();
        }
    }

    protected void onFulfilled(boolean newFailed) {
        this.thisGoal = this.next;
        if (this.thisGoal == null) {
            this.notifyOfStatus(EnumSet.of(QuestStatus.Fulfilled));
            return;
        }
        this.thisGoal.setSocket(this);
        this.thisGoal.reset();
        this.thisGoal.setActive(true);
        this.next = null;
        if (this.thisGoal instanceof ChainQuestGoal) {
            this.next = ((ChainQuestGoal)this.thisGoal).getNext();
            this.thisGoal = ((ChainQuestGoal)this.thisGoal).thisGoal;
        }
        if (this.next == null) {
            this.finalFailed = newFailed;
            this.notifyOfStatus(true, newFailed);
        } else {
            this.next.setSocket(this);
        }
    }

    protected void onFailed(boolean newFulfilled) {
        EnumSet<QuestStatus> e = EnumSet.of(QuestStatus.Failed);
        if (newFulfilled) {
            e.add(QuestStatus.Fulfilled);
        }
        this.notifyOfStatus(e);
    }

    protected void onNextNotified(EnumSet<QuestStatus> newStatus) {
    }

    protected void onUnknownStatusNotification(QuestGoal caller, EnumSet<QuestStatus> newStatus) {
        throw new IllegalArgumentException("ChainQuestGoal: A QuestGoal that is not our next goal should not notify us");
    }

    public QuestGoal getNext() {
        return this.next;
    }

    public void setNext(QuestGoal goal) {
        this.next = goal;
    }

    @Override
    public void reset() {
        this.thisGoal.reset();
        this.next.reset();
        EnumSet<QuestStatus> e = EnumSet.of(QuestStatus.Failed);
        if (this.isFulfilled()) {
            e.add(QuestStatus.Fulfilled);
        }
        if (this.isFailed()) {
            e.add(QuestStatus.Failed);
        }
        this.notifyOfStatus(e);
    }

    @Override
    public void setActive(boolean newActive) {
        if (this.thisGoal != null) {
            this.thisGoal.setActive(newActive);
        }
    }

    @Override
    public String modify(QuestRunningInformation.InformationType type, String current) {
        return this.thisGoal.modify(type, current);
    }
}

