/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.goals;

import java.util.Arrays;
import mhfc.net.common.eventhandler.quests.LivingDeathEventHandler;
import mhfc.net.common.eventhandler.quests.NotifyableQuestGoal;
import mhfc.net.common.eventhandler.quests.QuestGoalEventHandler;
import mhfc.net.common.quests.GeneralQuest;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.api.QuestGoal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class DeathRestrictionQuestGoal
extends QuestGoal
implements NotifyableQuestGoal<LivingDeathEvent> {
    protected int maxDeaths;
    protected int currentDeaths;
    protected QuestGoalEventHandler<LivingDeathEvent> handler;

    public DeathRestrictionQuestGoal(int maxDeaths) {
        this.maxDeaths = maxDeaths;
        this.currentDeaths = 0;
        this.handler = new LivingDeathEventHandler(this);
        this.handler.setActive(false);
        MinecraftForge.EVENT_BUS.register(this.handler);
    }

    @Override
    public boolean isFulfilled() {
        return this.maxDeaths >= this.currentDeaths;
    }

    @Override
    public boolean isFailed() {
        return this.maxDeaths < this.currentDeaths;
    }

    @Override
    public void reset() {
        this.currentDeaths = 0;
    }

    @Override
    public void setActive(boolean newActive) {
        this.handler.setActive(newActive);
    }

    @Override
    public void questGoalFinalize() {
        if (this.handler != null) {
            MinecraftForge.EVENT_BUS.unregister(this.handler);
        }
    }

    @Override
    public void notifyOfEvent(LivingDeathEvent event) {
        EntityPlayerMP[] players;
        GeneralQuest quest = this.getQuest();
        if (quest != null && (players = quest.getPlayers()) != null && Arrays.asList(players).contains(event.entityLiving)) {
            ++this.currentDeaths;
        }
        this.notifyOfStatus(this.isFulfilled(), this.isFailed());
    }

    @Override
    public String modify(QuestRunningInformation.InformationType type, String current) {
        if (type == QuestRunningInformation.InformationType.LongStatus) {
            current = current + (current.equals("") ? "" : "\n") + (this.maxDeaths - this.currentDeaths) + " respawns left";
        } else if (type == QuestRunningInformation.InformationType.ShortStatus) {
            current = current + (current.equals("") ? "" : "\n") + (this.maxDeaths - this.currentDeaths) + " respawns";
        }
        return current;
    }
}

