/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.goals;

import mhfc.net.common.eventhandler.quests.LivingDeathEventHandler;
import mhfc.net.common.eventhandler.quests.NotifyableQuestGoal;
import mhfc.net.common.eventhandler.quests.QuestGoalEventHandler;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.api.QuestGoalSocket;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class EntityQuestGoal
extends QuestGoal
implements NotifyableQuestGoal<LivingDeathEvent> {
    private EntityLivingBase entity;
    private boolean died;
    private NBTTagCompound nbt;
    private QuestGoalEventHandler<LivingDeathEvent> eventHandler;

    public EntityQuestGoal(QuestGoalSocket socket, EntityLivingBase entity) {
        super(socket);
        if (entity == null) {
            throw new IllegalArgumentException("The goal of an EntityQuestGoal can not be null");
        }
        this.entity = entity;
        this.died = !entity.func_70089_S();
        this.eventHandler = new LivingDeathEventHandler(this);
        this.nbt = new NBTTagCompound();
        entity.func_70109_d(this.nbt);
        MinecraftForge.EVENT_BUS.register(this.eventHandler);
    }

    @Override
    public boolean isFulfilled() {
        return this.died;
    }

    @Override
    public boolean isFailed() {
        return false;
    }

    @Override
    public void reset() {
        this.entity.func_70020_e(this.nbt);
        this.died = !this.entity.func_70089_S();
    }

    @Override
    public void questGoalFinalize() {
        MinecraftForge.EVENT_BUS.unregister(this.eventHandler);
    }

    @Override
    public void setActive(boolean newActive) {
        if (newActive) {
            this.died = this.entity.func_70089_S();
        }
        this.eventHandler.setActive(newActive);
    }

    @Override
    public void notifyOfEvent(LivingDeathEvent event) {
        if (event.entityLiving == this.entity) {
            this.died = true;
            this.notifyOfStatus(true, false);
        }
    }

    @Override
    public String modify(QuestRunningInformation.InformationType type, String current) {
        return current;
    }
}

