/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.goals;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import mhfc.net.MHFCMain;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.QuestStatus;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.api.QuestGoalSocket;

public class ForkQuestGoal
extends QuestGoal
implements QuestGoalSocket {
    protected List<QuestGoal> requisites = new LinkedList<QuestGoal>();
    protected List<QuestGoal> optional = new LinkedList<QuestGoal>();

    public ForkQuestGoal(QuestGoalSocket parent) {
        super(parent);
    }

    public void addRequisite(QuestGoal goal) {
        if (goal == null) {
            MHFCMain.logger.warn("ForkQuestGoal: Ignored requisite, a null goal is not valid");
            return;
        }
        this.requisites.add(goal);
        goal.setSocket(this);
        this.notifyOfStatus(this.isFulfilled(), this.isFailed());
    }

    public void addOptional(QuestGoal goal) {
        if (goal == null) {
            MHFCMain.logger.warn("ForkQuestGoal: Ignored optional, a null goal is not valid");
            return;
        }
        goal.setSocket(this);
        this.optional.add(goal);
    }

    @Override
    public boolean isFulfilled() {
        boolean fulfilled = true;
        for (QuestGoal g : this.requisites) {
            fulfilled &= g.isFulfilled();
        }
        return fulfilled;
    }

    @Override
    public boolean isFailed() {
        boolean failed = false;
        for (QuestGoal g : this.requisites) {
            failed |= g.isFailed();
        }
        return failed;
    }

    @Override
    public void questGoalStatusNotification(QuestGoal goal, EnumSet<QuestStatus> newStatus) {
        this.notifyOfStatus(this.isFulfilled(), this.isFailed());
    }

    @Override
    public void questGoalFinalize() {
        for (QuestGoal g : this.requisites) {
            g.questGoalFinalize();
        }
        for (QuestGoal g : this.optional) {
            g.questGoalFinalize();
        }
    }

    @Override
    public void reset() {
        for (QuestGoal g : this.requisites) {
            g.reset();
        }
        for (QuestGoal g : this.optional) {
            g.reset();
        }
        this.notifyOfStatus(this.isFulfilled(), this.isFailed());
    }

    @Override
    public void setActive(boolean newActive) {
        for (QuestGoal g : this.requisites) {
            g.setActive(newActive);
        }
        for (QuestGoal g : this.optional) {
            g.setActive(newActive);
        }
    }

    @Override
    public String modify(QuestRunningInformation.InformationType type, String current) {
        for (QuestGoal g : this.requisites) {
            current = g.modify(type, current);
        }
        if (type == QuestRunningInformation.InformationType.LongStatus) {
            if (this.optional.size() > 0) {
                current = current + "\n---------------";
            }
            for (QuestGoal g : this.optional) {
                current = g.modify(type, current);
            }
        }
        return current;
    }
}

