/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.goals;

import java.util.Arrays;
import java.util.List;
import mhfc.net.common.eventhandler.quests.LivingDeathEventHandler;
import mhfc.net.common.eventhandler.quests.NotifyableQuestGoal;
import mhfc.net.common.eventhandler.quests.QuestGoalEventHandler;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.api.QuestGoalSocket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class HuntingQuestGoal
extends QuestGoal
implements NotifyableQuestGoal<LivingDeathEvent> {
    private int goalNumber;
    private int currentNumber;
    private Class<?> goalClass;
    private QuestGoalEventHandler<LivingDeathEvent> goalHandler;

    public HuntingQuestGoal(QuestGoalSocket socket, Class<?> goalClass, int goalNumber) {
        super(socket);
        this.goalClass = goalClass;
        this.goalNumber = goalNumber;
        this.currentNumber = 0;
        this.goalHandler = new LivingDeathEventHandler(this);
        MinecraftForge.EVENT_BUS.register(this.goalHandler);
    }

    @Override
    public boolean isFulfilled() {
        return this.currentNumber >= this.goalNumber;
    }

    @Override
    public boolean isFailed() {
        return false;
    }

    @Override
    public void reset() {
        this.currentNumber = 0;
    }

    @Override
    public void questGoalFinalize() {
        MinecraftForge.EVENT_BUS.unregister(this.goalHandler);
    }

    @Override
    public void notifyOfEvent(LivingDeathEvent event) {
        if (this.goalClass.isAssignableFrom(event.entityLiving.getClass())) {
            Entity e = event.source.func_76346_g();
            if (!(e instanceof EntityPlayer)) {
                return;
            }
            if (this.getQuest() == null) {
                return;
            }
            List<EntityPlayerMP> playerList = Arrays.asList(this.getQuest().getPlayers());
            if (playerList == null) {
                return;
            }
            if (!playerList.contains(e)) {
                return;
            }
            ++this.currentNumber;
            this.notifyOfStatus(this.isFulfilled(), this.isFailed());
        }
    }

    @Override
    public void setActive(boolean newActive) {
        this.goalHandler.setActive(newActive);
    }

    @Override
    public String modify(QuestRunningInformation.InformationType type, String current) {
        if (type == QuestRunningInformation.InformationType.LongStatus) {
            current = current + (current.equals("") ? "" : "\n") + "Hunted " + this.currentNumber + " of " + this.goalNumber + " " + EntityList.field_75626_c.get(this.goalClass);
        } else if (type == QuestRunningInformation.InformationType.ShortStatus) {
            current = current + (current.equals("") ? "" : "\n") + this.currentNumber + "/" + this.goalNumber + " " + EntityList.field_75626_c.get(this.goalClass);
        }
        return current;
    }
}

