/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.quests.goals;

import mhfc.net.common.eventhandler.MHFCDelayedJob;
import mhfc.net.common.eventhandler.MHFCJobHandler;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.api.QuestGoal;
import mhfc.net.common.quests.api.QuestGoalSocket;

public class TimeQuestGoal
extends QuestGoal
implements MHFCDelayedJob {
    protected boolean isFailed = false;
    protected boolean active;
    protected int ticksToFail;
    protected long timeOfLastUpdate;
    protected int initialTicksToFail;

    public TimeQuestGoal(QuestGoalSocket socket, int initialTime) {
        super(socket);
        this.initialTicksToFail = initialTime;
        this.ticksToFail = initialTime;
        this.active = false;
    }

    public TimeQuestGoal(int initialTime) {
        this(null, initialTime);
    }

    @Override
    public boolean isFulfilled() {
        return !this.isFailed;
    }

    @Override
    public boolean isFailed() {
        return this.isFailed;
    }

    @Override
    public void reset() {
        MHFCJobHandler.instance().remove(this);
        this.isFailed = false;
        this.ticksToFail = this.initialTicksToFail;
    }

    @Override
    public void setActive(boolean newActive) {
        if (newActive) {
            if (this.ticksToFail > 0 && !this.active) {
                MHFCJobHandler.instance().insert(this, this.ticksToFail);
            }
            this.timeOfLastUpdate = System.currentTimeMillis();
            this.active = true;
            this.notifyOfStatus(this.isFulfilled(), this.isFailed());
        } else {
            int delay;
            this.ticksToFail = delay = MHFCJobHandler.instance().getDelay(this);
            MHFCJobHandler.instance().remove(this);
            this.active = false;
        }
    }

    @Override
    public void executeJob() {
        this.isFailed = true;
        this.notifyOfStatus(this.isFulfilled(), this.isFailed());
    }

    @Override
    public int getInitialDelay() {
        return this.initialTicksToFail;
    }

    @Override
    public void questGoalFinalize() {
        MHFCJobHandler.instance().remove(this);
    }

    @Override
    public String modify(QuestRunningInformation.InformationType type, String current) {
        int ticksToFail = MHFCJobHandler.instance().getDelay(this);
        if (ticksToFail < 0) {
            ticksToFail = this.initialTicksToFail;
        }
        switch (type) {
            case TimeLimit: {
                current = current + (current.endsWith("\n") || current.matches("\\s*") ? "" : "\n");
                if (this.active) {
                    current = current + "{time:" + ticksToFail + "}/ " + TimeQuestGoal.parseTimeFromTicks(this.initialTicksToFail);
                    break;
                }
                current = current + TimeQuestGoal.parseTimeFromTicks(ticksToFail);
                break;
            }
            case LongStatus: {
                current = current + (current.endsWith("\n") || current.matches("\\s*") ? "" : "\n");
                current = current + "Finish within " + (this.active ? " {time:" + ticksToFail + "} of " : "") + "a " + TimeQuestGoal.parseTimeFromTicks(this.initialTicksToFail) + "Time Limit";
                break;
            }
            case ShortStatus: {
                current = current + (current.endsWith("\n") || current.matches("\\s*") ? "" : "\n");
                if (this.active) {
                    current = current + "{time:" + ticksToFail + "} remaining";
                    break;
                }
                current = current + TimeQuestGoal.parseTimeFromTicks(ticksToFail) + "limit";
                break;
            }
        }
        return current;
    }

    private static String parseTimeFromTicks(long delta) {
        return "" + ((delta /= 50L) / 3600L > 0L ? delta / 3600L + "h " : "") + (delta % 3600L / 60L > 0L ? delta % 3600L / 60L + "min " : "") + (delta % 60L > 0L ? delta % 60L + "s " : "");
    }
}

