/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.system;

import cpw.mods.fml.common.event.FMLServerStartedEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mhfc.net.common.system.ColorSystem;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class UpdateSystem {
    private static final String urlString = "https://raw.githubusercontent.com/Guild-Hall/MHFC/master/build.properties";
    private static Future<UpdateInfo> updateInfo;

    public static void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UpdateInfo pollUpdate() {
        String current = "0.2.501a_1.7.10";
        try (BufferedReader versionFile = new BufferedReader(new InputStreamReader(new URL(urlString).openStream()));){
            String newVersionStr = versionFile.readLine();
            Matcher match = Pattern.compile("version\\s*=\\s*\\\"(.*?)\\\"").matcher(newVersionStr);
            if (!match.matches()) {
                UpdateInfo updateInfo = new UpdateInfo(UpdateStatus.FAILED, newVersionStr);
                return updateInfo;
            }
            newVersionStr = match.group(1);
            if (!current.equals(newVersionStr)) {
                UpdateInfo updateInfo = new UpdateInfo(UpdateStatus.NEWUPDATE, newVersionStr);
                return updateInfo;
            }
            UpdateInfo updateInfo = new UpdateInfo(UpdateStatus.NOUPDATE, current);
            return updateInfo;
        }
        catch (IOException e) {
            return new UpdateInfo(UpdateStatus.OFFLINE, current);
        }
    }

    public static UpdateInfo getUpdateInfo() {
        try {
            return updateInfo.get();
        }
        catch (InterruptedException e) {
            return new UpdateInfo(UpdateStatus.FAILED, "UNKNOWN");
        }
        catch (ExecutionException e) {
            return new UpdateInfo(UpdateStatus.FAILED, "UNKNOWN");
        }
    }

    public static void onServerStart(FMLServerStartedEvent sse) {
        if (sse.getSide().isServer()) {
            UpdateSystem.sendUpdateAsync((ICommandSender)MinecraftServer.func_71276_C());
        }
    }

    public static void sendUpdateAsync(final ICommandSender finalConsole) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                UpdateInfo info = UpdateSystem.getUpdateInfo();
                UpdateSystem.notifyOfUpdate(finalConsole, info);
            }
        }, "MHFC Update Notifier").start();
    }

    private static void notifyOfUpdate(ICommandSender console, UpdateInfo info) {
        switch (info.status) {
            case NEWUPDATE: {
                console.func_145747_a((IChatComponent)new ChatComponentText(ColorSystem.ENUMGOLD + "Hunter " + console.func_70005_c_() + ", a new version (" + info.version + ") of Monster Hunter Frontier Craft is out!" + " Check out the facebook page or the mod thread."));
                break;
            }
            case NOUPDATE: {
                console.func_145747_a((IChatComponent)new ChatComponentText(ColorSystem.ENUMGOLD + "Welcome Hunter " + console.func_70005_c_() + ", you're up to date, have fun hunting !!"));
                break;
            }
            case OFFLINE: {
                console.func_145747_a((IChatComponent)new ChatComponentText(ColorSystem.ENUMGOLD + "Hunter " + console.func_70005_c_() + ", unable to check for updates automatically"));
                console.func_145747_a((IChatComponent)new ChatComponentText("Make sure you frequently stop by on our facebook site or Minecraft forum thread!!"));
                break;
            }
            default: {
                console.func_145747_a((IChatComponent)new ChatComponentText(ColorSystem.ENUMRED + "MHFC: Unknown UpdateStatus, pls report with a logfile." + " Version info: " + info.version));
            }
        }
    }

    static {
        FutureTask<UpdateInfo> infoGetter = new FutureTask<UpdateInfo>(new Callable<UpdateInfo>(){

            @Override
            public UpdateInfo call() {
                return UpdateSystem.pollUpdate();
            }
        });
        new Thread(infoGetter, "MHFC Updater").start();
        updateInfo = infoGetter;
    }

    public static class UpdateInfo {
        public final UpdateStatus status;
        public final String version;

        public UpdateInfo(UpdateStatus status, String version) {
            this.status = Objects.requireNonNull(status);
            this.version = Objects.requireNonNull(version);
        }
    }

    public static enum UpdateStatus {
        NEWUPDATE,
        NOUPDATE,
        OFFLINE,
        FAILED;

    }
}

