/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.tile;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mhfc.net.common.core.registry.MHFCEquipementRecipeRegistry;
import mhfc.net.common.crafting.recipes.equipment.EquipmentRecipe;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.message.bench.MessageBeginCrafting;
import mhfc.net.common.network.message.bench.MessageBenchRefreshRequest;
import mhfc.net.common.network.message.bench.MessageCancelRecipe;
import mhfc.net.common.network.message.bench.MessageCraftingUpdate;
import mhfc.net.common.network.message.bench.MessageSetRecipe;
import mhfc.net.common.tile.TileMHFCUpdateStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileHunterBench
extends TileEntity
implements IInventory,
TileMHFCUpdateStream {
    public static final int outputSlot = 2;
    public static final int fuelSlot = 0;
    public static final int resultSlot = 1;
    private ItemStack fuelStack;
    private ItemStack resultStack;
    private ItemStack[] recipeStacks = new ItemStack[7];
    private ItemStack[] inputStacks = new ItemStack[this.recipeStacks.length];
    private ItemStack outputStack;
    private volatile int heatStrength;
    private volatile int heatFromItem;
    private volatile int heatLength;
    private int heatLengthInit = 1;
    private volatile int itemSmeltDuration;
    private EquipmentRecipe recipe;
    private volatile boolean workingMHFCBench = false;
    private static final String heatStrID = "heatStrength";
    private static final String heatFromItemID = "heatFromItem";
    private static final String heatLengthID = "heatLength";
    private static final String heatLengthInitID = "heatLengthInit";
    private static final String itemSmeltDurationID = "itemSmeltDuration";
    private static final String workingID = "workingID";
    private static final String recipeTypeID = "recipeType";
    private static final String recipeIDID = "recipeID";

    public int func_70302_i_() {
        return this.recipeStacks.length + this.inputStacks.length + 3;
    }

    public void func_145845_h() {
        if (this.heatLength > 0) {
            --this.heatLength;
            this.heatStrength = this.getNewHeat(this.heatStrength, this.heatFromItem);
            if (this.workingMHFCBench && this.recipe != null && this.heatStrength >= this.recipe.getRequiredHeat()) {
                ++this.itemSmeltDuration;
            }
        } else if (this.fuelStack != null && this.workingMHFCBench) {
            this.heatLengthInit = this.heatLength = TileEntityFurnace.func_145952_a((ItemStack)this.fuelStack);
            this.heatFromItem = TileHunterBench.getItemHeat(this.fuelStack);
            this.func_70298_a(0, 1);
            if (!this.field_145850_b.field_72995_K) {
                this.sendUpdateCraft();
            }
        } else {
            this.heatStrength = this.getNewHeat(this.heatStrength, 0);
        }
        if (this.recipe != null && this.itemSmeltDuration >= this.recipe.getDuration()) {
            this.finishRecipe();
        }
    }

    private void finishRecipe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.inputStacks = new ItemStack[this.inputStacks.length];
        this.outputStack = this.resultStack.func_77946_l();
        this.workingMHFCBench = false;
        this.itemSmeltDuration = 0;
        this.sendUpdateCraft();
    }

    @SideOnly(value=Side.CLIENT)
    public void forceEndCrafting(ItemStack stack) {
        this.outputStack = stack;
        this.inputStacks = new ItemStack[this.inputStacks.length];
        this.workingMHFCBench = false;
        this.itemSmeltDuration = 0;
    }

    public boolean isWorking() {
        return this.workingMHFCBench;
    }

    public void changeRecipe(EquipmentRecipe recipe) {
        if (this.field_145850_b.field_72995_K) {
            this.sendSetRecipe(recipe);
        }
        if (recipe != this.recipe) {
            this.cancelRecipe();
            this.setRecipe(recipe);
        }
    }

    protected void setRecipe(EquipmentRecipe recipe) {
        if (recipe == null) {
            this.recipeStacks = new ItemStack[7];
            this.recipe = null;
            this.resultStack = null;
        } else {
            this.resultStack = recipe.func_77571_b();
            this.recipe = recipe;
            this.setIngredients(recipe);
        }
    }

    public void setIngredients(EquipmentRecipe recipe) {
        this.recipeStacks = recipe.getRequirements(7);
    }

    public static int getItemHeat(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.func_77973_b() == Item.func_150899_d((int)327)) {
            return 1000;
        }
        return 200;
    }

    private int getNewHeat(int heatOld, int heatAim) {
        int diff = heatAim - heatOld;
        double change = Math.ceil(Math.log((double)Math.abs(diff) + 1.0));
        return heatOld + (int)(Math.ceil(change / 3.0) * (double)Math.signum(diff));
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        if (i >= this.recipeStacks.length + 3) {
            return this.inputStacks[i - 3 - this.recipeStacks.length];
        }
        if (i >= 3) {
            return this.recipeStacks[i - 3];
        }
        if (i == 2) {
            return this.outputStack;
        }
        if (i == 1) {
            return this.resultStack;
        }
        return this.fuelStack;
    }

    public ItemStack func_70298_a(int i, int j) {
        this.func_70296_d();
        if (j <= 0) {
            return null;
        }
        if (i > this.recipeStacks.length + 2) {
            ItemStack stack = this.inputStacks[i - this.recipeStacks.length - 3];
            if (stack == null) {
                return null;
            }
            this.cancelRecipe();
            if (j > stack.field_77994_a) {
                j = stack.field_77994_a;
            }
            if (j == stack.field_77994_a) {
                this.inputStacks[i - this.recipeStacks.length - 3] = null;
                return stack;
            }
            return stack.func_77979_a(j);
        }
        if (i > 2) {
            return null;
        }
        if (i == 2) {
            if (this.outputStack == null) {
                return null;
            }
            if (j > this.outputStack.field_77994_a) {
                j = this.outputStack.field_77994_a;
            }
            if (j == this.outputStack.field_77994_a) {
                ItemStack fuel = this.outputStack;
                this.outputStack = null;
                return fuel;
            }
            return this.outputStack.func_77979_a(j);
        }
        if (i == 1) {
            return null;
        }
        if (this.fuelStack == null) {
            return null;
        }
        if (j > this.fuelStack.field_77994_a) {
            j = this.fuelStack.field_77994_a;
        }
        if (j == this.fuelStack.field_77994_a) {
            ItemStack fuel = this.fuelStack;
            this.fuelStack = null;
            return fuel;
        }
        return this.fuelStack.func_77979_a(j);
    }

    public void cancelRecipe() {
        if (this.field_145850_b.field_72995_K) {
            this.sendCancelRecipe();
        }
        this.workingMHFCBench = false;
        this.itemSmeltDuration = 0;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i < 0 || i >= this.func_70302_i_()) {
            return;
        }
        if (i >= this.recipeStacks.length + 3) {
            this.inputStacks[i - this.recipeStacks.length - 3] = itemstack;
        } else if (i >= 3) {
            this.recipeStacks[i - 3] = itemstack;
        } else if (i == 2) {
            this.outputStack = itemstack;
        } else if (i == 1) {
            this.resultStack = itemstack;
        } else if (i == 0) {
            this.fuelStack = itemstack;
        }
    }

    public boolean isInvNameLocalized() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.func_145835_a(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 && TileEntityFurnace.func_145954_b((ItemStack)itemstack) || i > this.recipeStacks.length + 2 && i < this.recipeStacks.length * 2 + 3;
    }

    public String func_145825_b() {
        return "container.hunterbench";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean beginCrafting() {
        if (this.field_145850_b.field_72995_K) {
            this.sendBeginCraft();
        }
        if (this.recipe != null && this.canBeginCrafting()) {
            this.workingMHFCBench = true;
        }
        return this.workingMHFCBench;
    }

    @SideOnly(value=Side.CLIENT)
    private void sendBeginCraft() {
        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageBeginCrafting(this));
    }

    @SideOnly(value=Side.CLIENT)
    private void sendSetRecipe(EquipmentRecipe recipeToSend) {
        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageSetRecipe(this, recipeToSend));
    }

    @SideOnly(value=Side.CLIENT)
    private void sendCancelRecipe() {
        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageCancelRecipe(this));
    }

    @Override
    public void refreshState() {
        if (this.field_145850_b.field_72995_K) {
            PacketPipeline.networkPipe.sendToServer((IMessage)new MessageBenchRefreshRequest(this));
        }
    }

    private void sendUpdateCraft() {
        PacketPipeline.networkPipe.sendToAll((IMessage)new MessageCraftingUpdate(this));
    }

    public boolean canBeginCrafting() {
        return this.matchesInputOutput() && this.outputStack == null;
    }

    protected boolean matchesInputOutput() {
        for (int i = 0; i < this.inputStacks.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.inputStacks[i], (ItemStack)this.recipeStacks[i])) continue;
            return false;
        }
        return true;
    }

    public int getHeatStrength() {
        return this.heatStrength;
    }

    public int getBurningItemHeat() {
        return this.heatFromItem;
    }

    public int getHeatLength() {
        return this.heatLength;
    }

    public int getHeatLengthOriginal() {
        return this.heatLengthInit;
    }

    public int getItemSmeltDuration() {
        return this.itemSmeltDuration;
    }

    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.readCustomUpdate(nbtTag);
        NBTTagList items = nbtTag.func_150295_c("Items", 10);
        for (int a = 0; a < items.func_74745_c(); ++a) {
            NBTTagCompound stack = items.func_150305_b(a);
            byte id = stack.func_74771_c("Slot");
            if (id < 0 || id >= this.func_70302_i_()) continue;
            this.func_70299_a(id, ItemStack.func_77949_a((NBTTagCompound)stack));
        }
    }

    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        this.storeCustomUpdate(nbtTag);
        NBTTagList itemsStored = new NBTTagList();
        for (int a = 0; a < this.func_70302_i_(); ++a) {
            ItemStack s = this.func_70301_a(a);
            if (s == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)a);
            s.func_77955_b(tag);
            itemsStored.func_74742_a((NBTBase)tag);
        }
        nbtTag.func_74782_a("Items", (NBTBase)itemsStored);
    }

    public EquipmentRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public void storeCustomUpdate(NBTTagCompound nbtTag) {
        nbtTag.func_74768_a(heatStrID, this.heatStrength);
        nbtTag.func_74768_a(heatFromItemID, this.heatFromItem);
        nbtTag.func_74768_a(heatLengthID, this.heatLength);
        nbtTag.func_74768_a(heatLengthInitID, this.heatLengthInit);
        nbtTag.func_74768_a(itemSmeltDurationID, this.itemSmeltDuration);
        nbtTag.func_74757_a(workingID, this.workingMHFCBench);
        EquipmentRecipe.RecipeType type = this.recipe != null ? this.recipe.getRecipeType() : EquipmentRecipe.RecipeType.MHFC;
        int recipeID = MHFCEquipementRecipeRegistry.getIDFor(this.recipe);
        nbtTag.func_74768_a(recipeTypeID, type.ordinal());
        nbtTag.func_74768_a(recipeIDID, recipeID);
    }

    @Override
    public void readCustomUpdate(NBTTagCompound nbtTag) {
        this.heatStrength = nbtTag.func_74762_e(heatStrID);
        this.heatFromItem = nbtTag.func_74762_e(heatFromItemID);
        this.heatLength = nbtTag.func_74762_e(heatLengthID);
        this.heatLengthInit = nbtTag.func_74762_e(heatLengthInitID);
        this.itemSmeltDuration = nbtTag.func_74762_e(itemSmeltDurationID);
        this.workingMHFCBench = nbtTag.func_74767_n(workingID);
        int irecType = nbtTag.func_74762_e(recipeTypeID);
        int recId = nbtTag.func_74762_e(recipeIDID);
        EquipmentRecipe.RecipeType recType = EquipmentRecipe.RecipeType.values()[irecType];
        this.setRecipe(MHFCEquipementRecipeRegistry.getRecipeFor(recId, recType));
    }
}

