/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.util;

import java.util.List;
import mhfc.net.common.system.NBTSystem;
import net.minecraft.item.ItemStack;

public class Cooldown {
    public static final String COOLDOWN_NBT = "mhfc:cooldown";

    public static void onUpdate(ItemStack iStack, int maxCooldown) {
        NBTSystem.checkNBT(iStack);
        if (!NBTSystem.verifyKey(iStack, COOLDOWN_NBT)) {
            NBTSystem.setInteger(iStack, COOLDOWN_NBT, maxCooldown);
        }
        if (NBTSystem.getInteger(iStack, COOLDOWN_NBT) > 0) {
            NBTSystem.decreaseInteger(iStack, COOLDOWN_NBT, 1);
        }
    }

    public static boolean canUse(ItemStack iStack, int maxCooldown) {
        NBTSystem.checkNBT(iStack);
        if (NBTSystem.getInteger(iStack, COOLDOWN_NBT) > 0) {
            return false;
        }
        NBTSystem.setInteger(iStack, COOLDOWN_NBT, maxCooldown);
        return true;
    }

    public static void displayCooldown(ItemStack iStack, List<String> info, int maxCooldown) {
        NBTSystem.checkNBT(iStack);
        if (NBTSystem.getInteger(iStack, COOLDOWN_NBT) > 0) {
            info.add("Cooldown Time: " + NBTSystem.getInteger(iStack, COOLDOWN_NBT));
        } else {
            info.add("Cooldown Time: Ready to Use");
        }
    }

    public static void displayAttackDelay(ItemStack iStack, List<String> info, int maxCooldown) {
        NBTSystem.checkNBT(iStack);
        if (NBTSystem.getInteger(iStack, COOLDOWN_NBT) > 0) {
            info.add("Attack Time: " + NBTSystem.getInteger(iStack, COOLDOWN_NBT));
        } else {
            info.add("Attack Time: Ready");
        }
    }
}

