/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mhfc.net.MHFCMain;
import mhfc.net.common.eventhandler.MHFCDelayedJob;
import mhfc.net.common.eventhandler.MHFCJobHandler;
import net.minecraft.util.StatCollector;

public class MHFCStringDecode {
    private static Map<String, StringDecoderFactory> stringDecoderMap = new HashMap<String, StringDecoderFactory>();

    public static void init() {
    }

    public static boolean registerDecoder(String key, StringDecoderFactory decoder) {
        if (stringDecoderMap.containsKey(key)) {
            return false;
        }
        stringDecoderMap.put(key, decoder);
        return true;
    }

    public static boolean removeDecoder(StringDecoderFactory decoder) {
        if (!stringDecoderMap.containsValue(decoder)) {
            return false;
        }
        LinkedList<String> toRemove = new LinkedList<String>();
        for (String s : stringDecoderMap.keySet()) {
            if (stringDecoderMap.get(s) != null) continue;
            toRemove.add(s);
        }
        for (String s : toRemove) {
            stringDecoderMap.remove(s);
        }
        return !toRemove.isEmpty();
    }

    public static boolean removeKey(String key) {
        if (stringDecoderMap.containsKey(key)) {
            stringDecoderMap.remove(key);
            return true;
        }
        return false;
    }

    public static StringDecoder getNewDecoderFor(DynamicString dynString, String key) {
        return stringDecoderMap.get(key).getStringDecoder(dynString, key);
    }

    private static List<StringElement> breakApart(String str) {
        ArrayList<StringElement> list = new ArrayList<StringElement>(20);
        if (str == null) {
            return list;
        }
        boolean dynamic = true;
        String[] firstSplit = str.split("\\{");
        ArrayList<String> secondSplit = new ArrayList<String>();
        for (String part : firstSplit) {
            for (String small : part.split("\\}")) {
                secondSplit.add(small);
            }
        }
        for (String part : secondSplit) {
            boolean bl = dynamic = !dynamic;
            if (part.equals("")) continue;
            if (dynamic) {
                CompositeString s = MHFCStringDecode.getCompositeFor(part);
                list.add(s);
                continue;
            }
            list.add(new StaticString(part));
        }
        return list;
    }

    private static CompositeString getCompositeFor(String part) {
        return new DynamicString(part);
    }

    private static String decode(List<StringElement> elements) {
        if (elements == null) {
            return "NETD";
        }
        String output = "";
        for (int i = 0; i < elements.size(); ++i) {
            StringElement e = elements.get(i);
            if (e == null) continue;
            output = output + e.stringValue();
        }
        return output;
    }

    static {
        MHFCStringDecode.registerDecoder("time", new TimeTickDecoderFactory());
        MHFCStringDecode.registerDecoder("unlocalized", new LocalizationDecoderFactory());
    }

    public static class DynamicString
    extends CompositeString
    implements MHFCDelayedJob {
        protected Map<String, StringDecoder> personalDecoderMap = new HashMap<String, StringDecoder>();
        protected String stringValue;
        protected int delay;

        public DynamicString(String str) {
            super(str);
            this.executeJob();
        }

        @Override
        public void executeJob() {
            String superValue = super.stringValue();
            String[] split = superValue.split(":", 2);
            if (split.length == 1) {
                this.stringValue = split[0];
                this.delay = -1;
            } else {
                this.stringValue = this.findReplacement(superValue);
                this.delay = this.personalDecoderMap.get(split[0]).getUpdateDelay();
            }
            MHFCJobHandler.instance().insert(this, this.getInitialDelay());
            if (this.parent != null) {
                this.parent.childUpdated(this);
            }
        }

        @Override
        public int getInitialDelay() {
            return this.delay;
        }

        protected String findReplacement(String descriptor) {
            StringDecoder decoder;
            String[] split = descriptor.split(":", 2);
            String identifier = split[0];
            if (split.length == 1) {
                return identifier;
            }
            if (!this.personalDecoderMap.containsKey(identifier)) {
                this.personalDecoderMap.put(identifier, MHFCStringDecode.getNewDecoderFor(this, identifier));
            }
            if ((decoder = this.personalDecoderMap.get(identifier)) == null) {
                return "No decoder for " + identifier;
            }
            String replacement = decoder.getDecoded(identifier, split[1]);
            return replacement == null ? "unknown Descriptor " + descriptor : replacement;
        }

        @Override
        public String stringValue() {
            if (this.stringValue == null) {
                MHFCMain.logger.debug("String of dynamic string %s ended up as null", new Object[]{this.toString()});
            }
            return this.stringValue;
        }

        @Override
        public void remove() {
            MHFCJobHandler.instance().remove(this);
        }

        @Override
        public void childUpdated(CompositeString dynamicString) {
            MHFCJobHandler.instance().remove(this);
            this.executeJob();
        }
    }

    public static class StaticString
    implements StringElement {
        private String str;

        public StaticString(String str) {
            this.str = str;
        }

        @Override
        public String stringValue() {
            return this.str;
        }

        @Override
        public void remove() {
        }
    }

    public static class CompositeString
    implements StringElement {
        protected CompositeString parent;
        protected List<StringElement> parts = new LinkedList<StringElement>();

        public CompositeString(String toBreak) {
            this.parts.addAll(MHFCStringDecode.breakApart(toBreak));
            for (StringElement s : this.parts) {
                if (!(s instanceof CompositeString)) continue;
                ((CompositeString)s).setParent(this);
            }
        }

        public void setParent(CompositeString s) {
            this.parent = s;
        }

        @Override
        public String stringValue() {
            return MHFCStringDecode.decode(this.parts);
        }

        @Override
        public void remove() {
            for (StringElement e : this.parts) {
                e.remove();
            }
        }

        public void childUpdated(CompositeString dynamicString) {
        }
    }

    public static interface StringElement {
        public String stringValue();

        public void remove();
    }

    public static class LocalizationDecoder
    implements StringDecoder {
        @Override
        public int getUpdateDelay() {
            return -1;
        }

        @Override
        public String getDecoded(String key, String value) {
            if (value == null) {
                return null;
            }
            return StatCollector.func_74838_a((String)value);
        }
    }

    public static class TimeTickDecoder
    implements StringDecoder {
        private int ticksPassed;

        @Override
        public String getDecoded(String key, String value) {
            if (value == null) {
                return null;
            }
            long delta = Long.parseLong(value) - (long)this.ticksPassed;
            String ret = "" + ((delta /= 50L) >= 3600L ? delta / 3600L + "h " : "") + (delta >= 60L ? delta % 3600L / 60L + "min " : "") + (delta >= 0L ? delta % 60L : delta) + "s";
            this.ticksPassed += this.getUpdateDelay();
            return ret;
        }

        @Override
        public int getUpdateDelay() {
            return 50;
        }
    }

    public static interface StringDecoder {
        public int getUpdateDelay();

        public String getDecoded(String var1, String var2);
    }

    public static interface StringDecoderFactory {
        public StringDecoder getStringDecoder(DynamicString var1, String var2);
    }

    public static class LocalizationDecoderFactory
    implements StringDecoderFactory {
        @Override
        public StringDecoder getStringDecoder(DynamicString dynString, String key) {
            return new LocalizationDecoder();
        }
    }

    public static class TimeTickDecoderFactory
    implements StringDecoderFactory {
        @Override
        public StringDecoder getStringDecoder(DynamicString dynString, String key) {
            return new TimeTickDecoder();
        }
    }
}

