/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.util;

import java.util.List;
import java.util.Random;
import mhfc.net.common.core.registry.MHFCItemRegistry;
import mhfc.net.common.core.registry.MHFCPotionRegistry;
import mhfc.net.common.entity.projectile.EntityLightning;
import mhfc.net.common.entity.type.EntityWyvernHostile;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Utilities {
    private static Random rand = new Random();
    public static int motionTick;

    public static void removeAttackers(EntityLiving living) {
        List list = living.field_70170_p.func_72872_a(EntityLiving.class, living.field_70121_D.func_72314_b(16.0, 10.0, 16.0));
        for (EntityLiving attacker : list) {
            if (attacker == living || attacker.func_70638_az() != living) continue;
            attacker.func_70624_b(null);
            attacker.func_70604_c(null);
        }
    }

    public static void chargeMobToEntity(EntityWyvernHostile chargingEntity, Entity target, float distance, float moveSpeed, boolean dependsonWater) {
        PathEntity pathentity = chargingEntity.field_70170_p.func_72865_a((Entity)chargingEntity, target, 16.0f, false, false, dependsonWater, true);
        if (pathentity != null && distance < 12.0f) {
            chargingEntity.func_70778_a(pathentity);
            chargingEntity.speed = moveSpeed;
        }
        if (target != null) {
            dependsonWater = true;
            if (true) {
                chargingEntity.speed = (double)moveSpeed - 2.0;
            }
        }
    }

    public static void checkEntityPositionState(Entity ent, double xS, double yS, double zS, boolean isInLiquid) {
        double xLiqRadius = xS * Math.sin(ent.field_70165_t * Math.cos(xS - 2.0));
        double yLiqRadius = yS * Math.tanh(yS * Math.sin(yS * ent.field_70163_u));
        double zLiqRadius = zS * Math.sin(ent.field_70165_t * Math.cos(zS - 2.0));
        double setRadiusState = Math.toRadians(xLiqRadius / zLiqRadius) * Math.abs(yLiqRadius);
        if (ent.func_70038_c(xS, yS, zS)) {
            isInLiquid = true;
            ent.func_70091_d(xLiqRadius, yLiqRadius, zLiqRadius);
        } else if (ent.field_70145_X) {
            // empty if block
        }
    }

    public static int countPlayers(WorldServer worldObj) {
        return worldObj.field_73010_i.size();
    }

    public static void updateArmorTick(World world, EntityPlayer player) {
        ItemStack[] armorstack = new ItemStack[]{player.field_71071_by.func_70440_f(0), player.field_71071_by.func_70440_f(1), player.field_71071_by.func_70440_f(2), player.field_71071_by.func_70440_f(3)};
        if (armorstack[0] == null || armorstack[1] == null || armorstack[2] == null || armorstack[3] == null) {
            return;
        }
        if (armorstack[0].func_77973_b() == MHFCItemRegistry.armor_kirin_helm && armorstack[1].func_77973_b() == MHFCItemRegistry.armor_kirin_chest && armorstack[2].func_77973_b() == MHFCItemRegistry.armor_kirin_legs && armorstack[3].func_77973_b() == MHFCItemRegistry.armor_kirin_boots) {
            return;
        }
        if (armorstack[0].func_77973_b() == MHFCItemRegistry.armor_kirinS_helm && armorstack[1].func_77973_b() == MHFCItemRegistry.armor_kirinS_chest && armorstack[2].func_77973_b() == MHFCItemRegistry.armor_kirinS_legs && armorstack[3].func_77973_b() == MHFCItemRegistry.armor_kirinS_boots) {
            int duration = 15;
            player.func_70690_d(new PotionEffect(MHFCPotionRegistry.kirin_blessing.field_76415_H, duration++, 1));
            world.func_72869_a("cloud", player.field_70165_t + (double)(rand.nextFloat() * 2.0f) - 1.0, player.field_70163_u + (double)(rand.nextFloat() * 3.0f) + 1.0, player.field_70161_v + (double)(rand.nextFloat() * 2.0f) - 1.0, 0.0, 0.0, 0.0);
            return;
        }
        if (armorstack[0].func_77973_b() == MHFCItemRegistry.armor_tigrex_helm && armorstack[1].func_77973_b() == MHFCItemRegistry.armor_tigrex_chest && armorstack[2].func_77973_b() == MHFCItemRegistry.armor_tigrex_legs && armorstack[3].func_77973_b() == MHFCItemRegistry.armor_tigrex_boots) {
            return;
        }
        if (armorstack[0].func_77973_b() == MHFCItemRegistry.armor_rathalos_helm && armorstack[1].func_77973_b() == MHFCItemRegistry.armor_rathalos_chest && armorstack[2].func_77973_b() == MHFCItemRegistry.armor_rathalos_legs && armorstack[3].func_77973_b() == MHFCItemRegistry.armor_rathalos_boots) {
            return;
        }
    }

    public static void spawnLightnings(double Lx, double Ly, double Lz, int many, World world) {
        for (int i = 0; i < many; ++i) {
            EntityLightning l = new EntityLightning(world);
            l.func_70107_b(Lx, Ly, Lz);
            world.func_72838_d((Entity)l);
        }
    }

    public static float nullifyDamage(DamageSource source, float damage) {
        if (rand.nextInt(5) == 0 && source.func_76352_a()) {
            return 0.0f;
        }
        return damage;
    }

    public static void knockBack(EntityLivingBase attacker, EntityLivingBase entity, float knockback) {
        int knockBackModifier = EnchantmentHelper.func_77507_b((EntityLivingBase)attacker, (EntityLivingBase)entity);
        if (attacker.func_70051_ag()) {
            ++knockBackModifier;
        }
        double dx = attacker.field_70165_t - entity.field_70165_t;
        double dz = attacker.field_70161_v - entity.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        entity.field_70739_aP = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - entity.field_70177_z;
        float f = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        entity.field_70159_w -= dx / (double)f * (double)knockback;
        entity.field_70181_x += (double)knockback;
        entity.field_70179_y -= dz / (double)f * (double)knockback;
        if (entity.field_70181_x > 0.4) {
            entity.field_70181_x = 0.4;
        }
        if (knockBackModifier > 0) {
            dx = -Math.sin(Math.toRadians(attacker.field_70177_z)) * (double)knockBackModifier * 0.5;
            dz = Math.cos(Math.toRadians(attacker.field_70177_z)) * (double)knockBackModifier * 0.5;
            entity.func_70024_g(dx, 0.1, dz);
        }
    }
}

