/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.util.gui;

import mhfc.net.MHFCMain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;

public class MHFCGuiUtil {
    public static final int COLOUR_FOREGROUND = 14193980;
    public static final int COLOUR_TEXT = 0x404040;
    public static final int COLOUR_TITLE = 0;
    private static final String WIDTH_WARNING = "The width of the draw was smaller than the first character. This creates a stack overflow.\n Please don't do this, track it down. Stacktrace:";
    public static float zLevel;
    private static ScaledResolution s;

    public static int realScreenWidth(Minecraft mc) {
        if (mc == null) {
            throw new IllegalArgumentException("Gui utils may only be accessed with valid minecraft");
        }
        return mc.field_71443_c;
    }

    public static int realScreenHeight(Minecraft mc) {
        if (mc == null) {
            throw new IllegalArgumentException("Gui utils may only be accessed with valid minecraft");
        }
        return mc.field_71440_d;
    }

    public static int minecraftWidth(Minecraft mc) {
        MHFCGuiUtil.refreshScaled(mc);
        return s.func_78326_a();
    }

    public static int minecraftHeight(Minecraft mc) {
        MHFCGuiUtil.refreshScaled(mc);
        return s.func_78328_b();
    }

    public static int guiScaleFactor(Minecraft mc) {
        MHFCGuiUtil.refreshScaled(mc);
        return s.func_78325_e();
    }

    private static void refreshScaled(Minecraft mc) {
        if (mc == null) {
            throw new IllegalArgumentException("Gui utils may only be accessed with valid minecraft");
        }
        s = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
    }

    public static int drawTextAndReturnHeight(FontRenderer fRend, String string, int posX, int posY, int width, int colour) {
        if (fRend == null || string == null) {
            MHFCMain.logger.warn(fRend == null ? "Null renderer used as argument" : "Render request for a null string");
            Thread.dumpStack();
            return 0;
        }
        int lines = 1;
        if (width <= 0) {
            fRend.func_78276_b(string, posX, posY, colour);
        } else if (MHFCGuiUtil.isDrawWidthTooSmall(fRend, width, string)) {
            MHFCMain.logger.info(WIDTH_WARNING);
            Thread.dumpStack();
            lines = 0;
        } else {
            lines = fRend.func_78271_c(string, width).size();
            fRend.func_78279_b(string, posX, posY, width, colour);
        }
        return lines * fRend.field_78288_b;
    }

    public static boolean isDrawWidthTooSmall(FontRenderer fRend, int width, String string) {
        return !string.isEmpty() && width < fRend.func_78256_a(string.substring(0, 1));
    }

    public static void drawTexturedRectangle(double xMin, double yMin, double width, double height, float u, float v, float uWidth, float vHeight) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a(xMin, yMin, (double)zLevel, (double)u, (double)v);
        t.func_78374_a(xMin, yMin + height, (double)zLevel, (double)u, (double)(v + vHeight));
        t.func_78374_a(xMin + width, yMin + height, (double)zLevel, (double)(u + uWidth), (double)(v + vHeight));
        t.func_78374_a(xMin + width, yMin, (double)zLevel, (double)(u + uWidth), (double)v);
        t.func_78381_a();
    }

    public static void drawTexturedBoxFromBorder(float x, float y, float width, float height) {
        MHFCGuiUtil.drawTexturedBoxFromBorder(x, y, zLevel, width, height);
    }

    public static void drawTexturedBoxFromBorder(float x, float y, float zLevel, float width, float height) {
        MHFCGuiUtil.drawTexturedBoxFromBorder(x, y, zLevel, width, height, Math.min(Math.min(15.0f, width / 2.0f), height / 2.0f));
    }

    public static void drawTexturedBoxFromBorder(float x, float y, float zLevel, float width, float height, float borderSize) {
        MHFCGuiUtil.drawTexturedBoxFromBorder(x, y, zLevel, width, height, borderSize, borderSize / 256.0f);
    }

    public static void drawTexturedBoxFromBorder(float x, float y, float zLevel, float width, float height, float borderSize, float borderUV) {
        MHFCGuiUtil.drawTexturedBoxFromBorder(x, y, zLevel, width, height, borderSize, borderUV, 1.0f, 1.0f);
    }

    public static void drawTexturedBoxFromBorder(float x, float y, float zLevel, float width, float height, float borderSize, float borderUV, float maxU, float maxV) {
        MHFCGuiUtil.drawTexturedBoxFromBorder(x, y, zLevel, width, height, borderSize, borderUV, borderUV, maxU, maxV);
    }

    public static void drawTexturedBoxFromBorder(float x, float y, float zLevel, float width, float height, float borderSize, float borderU, float borderV, float maxU, float maxV) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        tess.func_78374_a((double)x, (double)(y + borderSize), (double)zLevel, 0.0, (double)borderV);
        tess.func_78374_a((double)(x + borderSize), (double)(y + borderSize), (double)zLevel, (double)borderU, (double)borderV);
        tess.func_78374_a((double)(x + borderSize), (double)y, (double)zLevel, (double)borderU, 0.0);
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78372_c(width - borderSize, 0.0f, 0.0f);
        tess.func_78374_a((double)x, (double)y, (double)zLevel, (double)(maxU - borderU), 0.0);
        tess.func_78374_a((double)x, (double)(y + borderSize), (double)zLevel, (double)(maxU - borderU), (double)borderV);
        tess.func_78374_a((double)(x + borderSize), (double)(y + borderSize), (double)zLevel, (double)maxU, (double)borderV);
        tess.func_78374_a((double)(x + borderSize), (double)y, (double)zLevel, (double)maxU, 0.0);
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78372_c(0.0f, height - borderSize, 0.0f);
        tess.func_78374_a((double)x, (double)y, (double)zLevel, (double)(maxU - borderU), (double)(maxV - borderV));
        tess.func_78374_a((double)x, (double)(y + borderSize), (double)zLevel, (double)(maxU - borderU), (double)maxV);
        tess.func_78374_a((double)(x + borderSize), (double)(y + borderSize), (double)zLevel, (double)maxU, (double)maxV);
        tess.func_78374_a((double)(x + borderSize), (double)y, (double)zLevel, (double)maxU, (double)(maxV - borderV));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78372_c(-width + borderSize, 0.0f, 0.0f);
        tess.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, (double)(maxV - borderV));
        tess.func_78374_a((double)x, (double)(y + borderSize), (double)zLevel, 0.0, (double)maxV);
        tess.func_78374_a((double)(x + borderSize), (double)(y + borderSize), (double)zLevel, (double)borderU, (double)maxV);
        tess.func_78374_a((double)(x + borderSize), (double)y, (double)zLevel, (double)borderU, (double)(maxV - borderV));
        tess.func_78381_a();
        tess.func_78372_c(0.0f, -height + borderSize, 0.0f);
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + borderSize), (double)zLevel, 0.0, (double)borderV);
        tess.func_78374_a((double)x, (double)(y + height - borderSize), (double)zLevel, 0.0, (double)(maxV - borderV));
        tess.func_78374_a((double)(x + borderSize), (double)(y + height - borderSize), (double)zLevel, (double)borderU, (double)(maxV - borderV));
        tess.func_78374_a((double)(x + borderSize), (double)(y + borderSize), (double)zLevel, (double)borderU, (double)borderV);
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a((double)(x + width - borderSize), (double)(y + borderSize), (double)zLevel, (double)(maxU - borderU), (double)borderV);
        tess.func_78374_a((double)(x + width - borderSize), (double)(y + height - borderSize), (double)zLevel, (double)(maxU - borderU), (double)(maxV - borderV));
        tess.func_78374_a((double)(x + width), (double)(y + height - borderSize), (double)zLevel, (double)maxU, (double)(maxV - borderV));
        tess.func_78374_a((double)(x + width), (double)(y + borderSize), (double)zLevel, (double)maxU, (double)borderV);
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a((double)(x + borderSize), (double)y, (double)zLevel, (double)borderU, 0.0);
        tess.func_78374_a((double)(x + borderSize), (double)(y + borderSize), (double)zLevel, (double)borderU, (double)borderV);
        tess.func_78374_a((double)(x + width - borderSize), (double)(y + borderSize), (double)zLevel, (double)(maxU - borderU), (double)borderV);
        tess.func_78374_a((double)(x + width - borderSize), (double)y, (double)zLevel, (double)(maxU - borderU), 0.0);
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a((double)(x + borderSize), (double)(y + height - borderSize), (double)zLevel, (double)borderU, (double)(maxV - borderV));
        tess.func_78374_a((double)(x + borderSize), (double)(y + height), (double)zLevel, (double)borderU, (double)maxV);
        tess.func_78374_a((double)(x + width - borderSize), (double)(y + height), (double)zLevel, (double)(maxU - borderU), (double)maxV);
        tess.func_78374_a((double)(x + width - borderSize), (double)(y + height - borderSize), (double)zLevel, (double)(maxU - borderU), (double)(maxV - borderV));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a((double)(x + borderSize), (double)(y + borderSize), (double)zLevel, (double)borderU, (double)borderV);
        tess.func_78374_a((double)(x + borderSize), (double)(y + height - borderSize), (double)zLevel, (double)borderU, (double)(maxV - borderV));
        tess.func_78374_a((double)(x + width - borderSize), (double)(y + height - borderSize), (double)zLevel, (double)(maxU - borderU), (double)(maxV - borderV));
        tess.func_78374_a((double)(x + width - borderSize), (double)(y + borderSize), (double)zLevel, (double)(maxU - borderU), (double)borderV);
        tess.func_78381_a();
    }
}

