/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.weapon;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mhfc.net.common.util.Attributes;
import mhfc.net.common.util.Utilities;
import mhfc.net.common.weapon.AbstractWeaponClass;
import mhfc.net.common.weapon.melee.IPerception;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ComponentMelee
extends AbstractWeaponClass {
    public final WeaponSpecs weaponSpecs;
    public final Item.ToolMaterial weaponMaterial;

    public ComponentMelee(WeaponSpecs meleespecs, Item.ToolMaterial toolmaterial) {
        this.weaponSpecs = meleespecs;
        this.weaponMaterial = toolmaterial;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public void setThisItemProperties() {
        if (this.weaponMaterial == null) {
            this.item.func_77656_e(this.weaponSpecs.durabilityBase);
        } else {
            this.item.func_77656_e((int)((float)this.weaponSpecs.durabilityBase + (float)this.weaponMaterial.func_77997_a() * this.weaponSpecs.damageMult));
        }
        this.item.func_77625_d(this.weaponSpecs.stackSize);
    }

    @Override
    public float getEntityDamageMaterialPart() {
        if (this.weaponMaterial == null) {
            return 0.0f;
        }
        return this.weaponMaterial.func_78000_c() * this.weaponSpecs.damageMult;
    }

    @Override
    public float getEntityDamage() {
        return this.weaponSpecs.attackBase + this.getEntityDamageMaterialPart();
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, Block block) {
        if (this.canHarvestBlock(block)) {
            return this.weaponSpecs.blockDamage * 10.0f;
        }
        Material material = block.func_149688_o();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : this.weaponSpecs.blockDamage;
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        return block == Blocks.field_150321_G;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, int j, int k, int l, EntityLivingBase entityliving) {
        if ((this.weaponSpecs.blockDamage > 1.0f || this.canHarvestBlock(block)) && block.func_149712_f(world, j, k, l) != 0.0f) {
            itemstack.func_77972_a(this.weaponSpecs.dmgFromBlock, entityliving);
        }
        return true;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (entityliving.field_70172_ad == entityliving.field_70771_an) {
            float kb = this.getKnockBack(itemstack, entityliving, attacker);
            Utilities.knockBack(entityliving, attacker, kb);
            entityliving.field_70172_ad += this.getAttackDelay(itemstack, entityliving, attacker);
        }
        itemstack.func_77972_a(this.weaponSpecs.damageincome, attacker);
        return true;
    }

    @Override
    public int getAttackDelay(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return this.weaponSpecs.comboRate;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return this.weaponSpecs.getKnockBack(this.weaponMaterial);
    }

    @Override
    public int getItemEnchantability() {
        return this.weaponMaterial == null ? 1 : this.weaponMaterial.func_77995_e();
    }

    @Override
    public void addItemAttributeModifiers(Multimap<String, AttributeModifier> multimap) {
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.weaponSpecs.damageMult > 0.0f) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon modifier", (double)(dmg - 4.0f), 0));
        }
        multimap.put((Object)Attributes.WEAPON_KNOCKBACK.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon knockback modifier", (double)(this.weaponSpecs.getKnockBack(this.weaponMaterial) - 0.6f + 12.0f), 0));
        multimap.put((Object)Attributes.ATTACK_SPEED.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon attack speed modifier", (double)(this.weaponSpecs.comboRate * -4), 0));
        if (this instanceof IPerception) {
            try {
                multimap.put((Object)Attributes.WEAPON_REACH.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon reach modifier", (double)(((IPerception)((Object)this)).getExtendedReach(null, null, null) - 3.0f), 0));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer player, Entity entity) {
        return false;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.block;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.func_71008_a(itemstack, this.getMaxItemUseDuration(itemstack));
        return itemstack;
    }

    @Override
    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
    }

    @Override
    public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    public static enum WeaponSpecs {
        GREATSWORD(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.5f, 1, 2, 1, 3),
        HAMMER(0, 1.0f, 4.0f, 1.0f, 1.0f, 0.9f, 1, 2, 1, 9),
        HUNTINGHORN(0, 0.5f, 3.0f, 1.0f, 1.5f, 0.6f, 1, 2, 1, 6),
        LONGSWORD(0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1, 2, 1, -4),
        NONE(0, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 0, 0, 1, 0);

        public final int durabilityBase;
        public final float durabilityMult;
        public final float attackBase;
        public final float damageMult;
        public final float blockDamage;
        public final float fencerate;
        public final int damageincome;
        public final int dmgFromBlock;
        public final int stackSize;
        public final int comboRate;

        private WeaponSpecs(int durbase, float durmult, float attackbase, float dmgmult, float blockrate, float fencing, int incomeDamage, int dmgfromblock, int stacksize, int comborate) {
            this.durabilityBase = durbase;
            this.durabilityMult = durmult;
            this.attackBase = attackbase;
            this.damageMult = dmgmult;
            this.blockDamage = blockrate;
            this.fencerate = fencing;
            this.damageincome = incomeDamage;
            this.dmgFromBlock = dmgfromblock;
            this.stackSize = stacksize;
            this.comboRate = comborate;
        }

        public float getKnockBack(Item.ToolMaterial material) {
            return material == Item.ToolMaterial.GOLD ? this.fencerate * 1.5f : this.fencerate;
        }
    }
}

