/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel;

import com.github.worldsender.mcanm.MCAnm;
import com.github.worldsender.mcanm.Reference;
import com.github.worldsender.mcanm.client.model.mcanmmodel.ModelMCMD;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RawData;
import com.github.worldsender.mcanm.client.model.mcanmmodel.loader.VersionizedModelLoader;
import com.github.worldsender.mcanm.client.model.util.ModelLoader;
import java.io.DataInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustomLoader;
import net.minecraftforge.client.model.ModelFormatException;

public class MCMDModelLoader
implements IModelCustomLoader {
    public static final MCMDModelLoader instance = new MCMDModelLoader();

    public String getType() {
        return "model_type";
    }

    public String[] getSuffixes() {
        return Reference.model_suffix_list;
    }

    public static ModelMCMD loadModel(ResourceLocation resLoc) {
        return instance.loadInstance(resLoc);
    }

    public ModelMCMD loadInstance(ResourceLocation resource) {
        return this.loadInstance(resource, Minecraft.func_71410_x().func_110442_L(), true);
    }

    public ModelMCMD loadInstance(ResourceLocation resource, IResourceManager resManager, boolean register) {
        ModelMCMD model = new ModelMCMD(resource, resManager);
        if (register) {
            ModelLoader.instance.registerModel(model);
        }
        return model;
    }

    public ModelMCMD loadChecked(ResourceLocation resLocation, IResourceManager resManager) throws ModelFormatException {
        MCAnm.logger.trace(String.format("[Model] Attempting to load model from resource: %s", resLocation));
        RawData loadedData = VersionizedModelLoader.loadVersionized(resLocation, resManager);
        return new ModelMCMD(loadedData);
    }

    public ModelMCMD loadFromStream(DataInputStream dis, String filename) throws ModelFormatException {
        MCAnm.logger.trace(String.format("[Model] Attempting to load model from stream: %s", filename));
        RawData loadedData = VersionizedModelLoader.loadVersionized(dis, filename);
        return new ModelMCMD(loadedData);
    }
}

