/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel;

import com.github.worldsender.mcanm.MCAnm;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RawData;
import com.github.worldsender.mcanm.client.model.mcanmmodel.glcontext.GLHelper;
import com.github.worldsender.mcanm.client.model.mcanmmodel.loader.VersionizedModelLoader;
import com.github.worldsender.mcanm.client.renderer.IAnimatedObject;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.ModelFormatException;

public class ModelMCMD
implements IModelCustom {
    private GLHelper renderHelper = GLHelper.getNewAppropriateHelper();
    private ResourceLocation reloadLocation;
    private String artist;
    private UUID modelUUID;

    private static RawData loadDataChecked(ResourceLocation resource, IResourceManager resManager) {
        try {
            return VersionizedModelLoader.loadVersionized(resource, resManager);
        }
        catch (ModelFormatException mfe) {
            MCAnm.logger.error(String.format("Error loading model from %s.", resource), (Throwable)mfe);
            return null;
        }
    }

    public ModelMCMD(ResourceLocation resource) {
        this(resource, Minecraft.func_71410_x().func_110442_L());
    }

    public ModelMCMD(ResourceLocation resource, IResourceManager resManager) {
        this(ModelMCMD.loadDataChecked(resource, resManager));
        MCAnm.logger.trace(String.format("[Model] Loading model from resource: %s", resource));
    }

    protected ModelMCMD(RawData data) {
        this.putData(data);
    }

    public void reload(IResourceManager newManager) {
        if (this.reloadLocation == null) {
            return;
        }
        try {
            RawData data = VersionizedModelLoader.loadVersionized(this.reloadLocation, newManager);
            this.putData(data);
        }
        catch (ModelFormatException modelFormatException) {
            // empty catch block
        }
    }

    private void putData(RawData data) {
        if (data != null) {
            this.renderHelper.loadInto(data);
            this.artist = data.artist;
            this.modelUUID = data.modelUUID;
            this.reloadLocation = data.srcLocation;
        } else {
            this.artist = "UNKOWN_ARTIST";
            this.modelUUID = new UUID(0L, 0L);
            this.reloadLocation = null;
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.reloadLocation;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelMCMD)) {
            return false;
        }
        ModelMCMD other = (ModelMCMD)obj;
        if (this.reloadLocation != null && this.reloadLocation.equals((Object)other.reloadLocation)) {
            return true;
        }
        return this.modelUUID == other.modelUUID;
    }

    public int hashCode() {
        return this.modelUUID.hashCode() ^ this.reloadLocation.hashCode();
    }

    public void render(IAnimatedObject object, float parTick) {
        this.renderHelper.render(object, parTick);
    }

    public String getType() {
        return "model_type";
    }

    public String getArtist() {
        return this.artist;
    }

    public UUID getModelUUID() {
        return this.modelUUID;
    }

    private static void throwUsage() {
        throw new IllegalAccessError("Can't use this method with this model-type. Use one of #render(...)");
    }

    public void renderAll() {
        ModelMCMD.throwUsage();
    }

    public void renderOnly(String ... groupNames) {
        ModelMCMD.throwUsage();
    }

    public void renderPart(String partName) {
        ModelMCMD.throwUsage();
    }

    public void renderAllExcept(String ... excludedGroupNames) {
        ModelMCMD.throwUsage();
    }
}

