/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.Arrays;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import sun.nio.cs.ArrayDecoder;

public class Utils {
    private static CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);

    public static String readString(DataInputStream dis) throws MalformedInputException, UnmappableCharacterException, IOException {
        int currByte;
        byte[] buffer = new byte[64];
        int currLength = 64;
        int offset = 0;
        while ((currByte = dis.read()) > 0) {
            if (offset == currLength) {
                buffer = Arrays.copyOf(buffer, currLength += 64);
            }
            buffer[offset++] = (byte)currByte;
        }
        if (offset == 0) {
            return "";
        }
        utf8Decoder.reset();
        int strLen = 0;
        int maxLen = (int)Math.ceil((float)offset * utf8Decoder.maxCharsPerByte());
        char[] target = new char[maxLen];
        if (utf8Decoder instanceof ArrayDecoder) {
            strLen = ((ArrayDecoder)((Object)utf8Decoder)).decode(buffer, 0, offset, target);
        } else {
            ByteBuffer sourceBuff = ByteBuffer.wrap(buffer, 0, offset);
            CharBuffer targetBuff = CharBuffer.wrap(target);
            try {
                CoderResult cr = utf8Decoder.decode(sourceBuff, targetBuff, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = utf8Decoder.flush(targetBuff)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException x) {
                // empty catch block
            }
            strLen = targetBuff.position();
        }
        return new String(target, 0, strLen);
    }

    public static Vector2f readVector2f(DataInputStream dis) throws EOFException, IOException {
        float x = dis.readFloat();
        float y = dis.readFloat();
        return new Vector2f(x, y);
    }

    public static Vector3f readVector3f(DataInputStream dis) throws EOFException, IOException {
        float x = dis.readFloat();
        float y = dis.readFloat();
        float z = dis.readFloat();
        return new Vector3f(x, y, z);
    }

    public static Quaternion readQuat(DataInputStream dis) throws EOFException, IOException {
        float x = dis.readFloat();
        float y = dis.readFloat();
        float z = dis.readFloat();
        float w = dis.readFloat();
        return new Quaternion(x, y, z, w);
    }

    public static ByteBuffer directByteBuffer(int size) {
        return GLAllocation.func_74524_c((int)size);
    }

    public static IntBuffer directIntBuffer(int size) {
        return GLAllocation.func_74527_f((int)size);
    }

    public static FloatBuffer directFloatBuffer(int size) {
        return GLAllocation.func_74529_h((int)size);
    }

    public static DoubleBuffer directDoubleBuffer(int size) {
        return Utils.directByteBuffer(size * 4).asDoubleBuffer();
    }

    public static ShortBuffer directShortBuffer(int size) {
        return Utils.directByteBuffer(size * 2).asShortBuffer();
    }

    public static ByteBuffer getShaderSource(InputStream is) throws IOException {
        ReadableByteChannel readChannel = Channels.newChannel(is);
        int bufferSize = 4096;
        ByteBuffer target = Utils.directByteBuffer(bufferSize);
        while (readChannel.read(target) > 0 && !target.hasRemaining()) {
            target.flip();
            target = Utils.directByteBuffer(bufferSize += 4096).put(target);
        }
        target.flip();
        return target;
    }

    public static int compileShaderSafe(int shaderType, InputStream is) throws IOException {
        int shaderName = GL20.glCreateShader((int)shaderType);
        if (shaderName == 0) {
            throw new IllegalStateException("GL Error: Created Shader is 0. Can't proceed.");
        }
        ByteBuffer shaderSource = Utils.getShaderSource(is);
        GL20.glShaderSource((int)shaderName, (ByteBuffer)shaderSource);
        GL20.glCompileShader((int)shaderName);
        if (GL20.glGetShaderi((int)shaderName, (int)35713) == 0) {
            int errorLength = GL20.glGetShaderi((int)shaderName, (int)35716);
            String error = GL20.glGetShaderInfoLog((int)shaderName, (int)errorLength);
            GL20.glDeleteShader((int)shaderName);
            throw new IllegalStateException(error);
        }
        return shaderName;
    }

    public static int createProgramSafe() {
        int programName = GL20.glCreateProgram();
        if (programName == 0) {
            throw new IllegalStateException("GL Error: Created Program is 0. Can't proceed.");
        }
        return programName;
    }

    public static int getShader(int program, int searchedType) {
        int shaderCount = GL20.glGetProgrami((int)program, (int)35717);
        IntBuffer attachedShaders = Utils.directIntBuffer(shaderCount);
        IntBuffer count = Utils.directIntBuffer(1);
        GL20.glGetAttachedShaders((int)program, (IntBuffer)count, (IntBuffer)attachedShaders);
        assert (count.get() == shaderCount);
        for (int i = 0; i < shaderCount; ++i) {
            int shaderCandidate = attachedShaders.get();
            if (searchedType != GL20.glGetShaderi((int)shaderCandidate, (int)35663)) continue;
            return shaderCandidate;
        }
        return 0;
    }

    public static void linkProgramSafe(int program) {
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            int errorLength = GL20.glGetProgrami((int)program, (int)35716);
            String error = GL20.glGetProgramInfoLog((int)program, (int)errorLength);
            throw new IllegalStateException(error);
        }
    }

    public static Matrix4f fromRotTrans(Quaternion q, Vector3f off, float scale) {
        Matrix4f mat = new Matrix4f();
        if (q != null) {
            Quat4f quat = new Quat4f(q.x, q.y, q.z, q.w);
            Matrix3f rotMat = new Matrix3f();
            rotMat.set(quat);
            mat.m00 = rotMat.m00;
            mat.m10 = rotMat.m01;
            mat.m20 = rotMat.m02;
            mat.m01 = rotMat.m10;
            mat.m11 = rotMat.m11;
            mat.m21 = rotMat.m12;
            mat.m02 = rotMat.m20;
            mat.m12 = rotMat.m21;
            mat.m22 = rotMat.m22;
        }
        if (off != null) {
            mat.m30 = off.x * scale;
            mat.m31 = off.y * scale;
            mat.m32 = off.z * scale;
        }
        return mat;
    }
}

