/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.animation;

import com.github.worldsender.mcanm.client.model.mcanmmodel.Utils;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector3f;

public interface IAnimation {
    public BoneTransformation getCurrentTransformation(String var1, float var2);

    public static class BoneTransformation {
        public static final BoneTransformation identity = new BoneTransformation();
        private Quaternion rotationQuat;
        private Vector3f translation;
        private Vector3f scale;

        private static Vector3f identityScale() {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }

        public BoneTransformation() {
            this(new Vector3f(), new Quaternion(), BoneTransformation.identityScale());
        }

        public BoneTransformation(Vector3f translation, Quaternion quat) {
            this(translation, quat, BoneTransformation.identityScale());
        }

        public BoneTransformation(Vector3f translation, Quaternion quat, Vector3f scale) {
            if (quat == null) {
                quat = new Quaternion();
            }
            if (translation == null) {
                translation = new Vector3f();
            }
            if (scale == null) {
                scale = BoneTransformation.identityScale();
            }
            this.rotationQuat = quat;
            this.translation = translation;
            this.scale = scale;
        }

        public Matrix4f asMatrix() {
            Matrix4f mat = Utils.fromRotTrans(this.rotationQuat, this.translation, 1.0f);
            mat.scale(this.scale);
            return mat;
        }
    }
}

