/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored;

import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.IAnimation;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.AnimatedValue;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraftforge.client.model.ModelFormatException;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector3f;

public class AnimatedTransform {
    private AnimatedValue loc_x;
    private AnimatedValue loc_y;
    private AnimatedValue loc_z;
    private AnimatedValue quat_x;
    private AnimatedValue quat_y;
    private AnimatedValue quat_z;
    private AnimatedValue quat_w;
    private AnimatedValue scale_x;
    private AnimatedValue scale_y;
    private AnimatedValue scale_z;

    public AnimatedTransform(DataInputStream dis) throws ModelFormatException, IOException {
        this.loc_x = new AnimatedValue(0.0f, dis);
        this.loc_y = new AnimatedValue(0.0f, dis);
        this.loc_z = new AnimatedValue(0.0f, dis);
        this.quat_x = new AnimatedValue(0.0f, dis);
        this.quat_y = new AnimatedValue(0.0f, dis);
        this.quat_z = new AnimatedValue(0.0f, dis);
        this.quat_w = new AnimatedValue(1.0f, dis);
        this.scale_x = new AnimatedValue(1.0f, dis);
        this.scale_y = new AnimatedValue(1.0f, dis);
        this.scale_z = new AnimatedValue(1.0f, dis);
    }

    public IAnimation.BoneTransformation getTransformAt(float frame) {
        Vector3f translation = new Vector3f(this.loc_x.getValueAt(frame), this.loc_y.getValueAt(frame), this.loc_z.getValueAt(frame));
        Quaternion quaternion = new Quaternion(this.quat_x.getValueAt(frame), this.quat_y.getValueAt(frame), this.quat_z.getValueAt(frame), this.quat_w.getValueAt(frame));
        quaternion = quaternion.normalise(quaternion);
        Vector3f scale = new Vector3f(this.scale_x.getValueAt(frame), this.scale_y.getValueAt(frame), this.scale_z.getValueAt(frame));
        return new IAnimation.BoneTransformation(translation, quaternion, scale);
    }
}

