/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored;

import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.Spline;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.client.model.ModelFormatException;
import org.lwjgl.util.vector.Vector2f;

public class AnimatedValue {
    private List<Spline> splines;
    private float defaultValue;

    public AnimatedValue(float defaultValue, DataInputStream dis) throws ModelFormatException, IOException {
        this.defaultValue = defaultValue;
        this.splines = new ArrayList<Spline>();
        int nbrFrames = dis.readUnsignedShort();
        if (nbrFrames == 0) {
            Vector2f point = new Vector2f(0.0f, defaultValue);
            this.splines.add(Spline.easeIn((byte)0, point, dis));
            this.splines.add(Spline.easeOut((byte)16, point, dis));
        } else {
            Vector2f left = null;
            Vector2f right = Spline.readPoint(dis);
            byte easeIn = dis.readByte();
            this.splines.add(Spline.easeIn(easeIn, right, dis));
            for (int i = 1; i < nbrFrames; ++i) {
                left = right;
                right = Spline.readPoint(dis);
                byte interpolation = dis.readByte();
                this.splines.add(Spline.interpolating(interpolation, left, right, dis));
            }
            byte easeOut = dis.readByte();
            this.splines.add(Spline.easeOut(easeOut, right, dis));
        }
    }

    public float getValueAt(float time) {
        for (Spline spline : this.splines) {
            if (!spline.isInRange(time)) continue;
            return spline.getValueAt(time);
        }
        return this.defaultValue;
    }
}

