/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored;

import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.Spline;
import java.io.DataInputStream;
import java.io.IOException;
import org.lwjgl.util.vector.Vector2f;

public class BSplineInterpolation
extends Spline {
    public static final Spline.IInterpolationSplineFactory factory = new Spline.IInterpolationSplineFactory(){

        @Override
        public Spline newSpline(Vector2f left, Vector2f right, DataInputStream additionalData) throws IOException {
            Vector2f leftHandle = Spline.readPoint(additionalData);
            Vector2f rightHandle = Spline.readPoint(additionalData);
            return new BSplineInterpolation(left, leftHandle, rightHandle, right);
        }
    };
    private Vector2f left;
    private Vector2f leftHandle;
    private Vector2f rightHandle;
    private Vector2f right;

    public BSplineInterpolation(Vector2f left, Vector2f leftHandle, Vector2f rightHandle, Vector2f right) {
        this.left = left;
        this.leftHandle = leftHandle;
        this.rightHandle = rightHandle;
        this.right = right;
    }

    @Override
    public boolean isInRange(float frame) {
        return frame >= this.left.x && frame <= this.right.x;
    }

    @Override
    public float getValueAt(float frame) {
        if (frame == this.left.x) {
            return this.left.y;
        }
        if (frame == this.right.x) {
            return this.right.y;
        }
        double t = BSplineInterpolation.findZero(this.left.x, this.leftHandle.x, this.rightHandle.x, this.right.x, frame);
        return BSplineInterpolation.calcValue(this.left.y, this.leftHandle.y, this.rightHandle.y, this.right.y, t);
    }

    private static double findZero(float x1, float x2, float x3, float x4, float x) {
        double c0 = x1 - x;
        double c1 = 3.0f * (x2 - x1);
        double c2 = 3.0f * (x1 - 2.0f * x2 + x3);
        double c3 = x4 - x1 + 3.0f * (x2 - x3);
        if (c3 != 0.0) {
            double p;
            double q;
            double d;
            double a = c2 / c3;
            double b = c1 / c3;
            double c = c0 / c3;
            if ((d = (q = (2.0 * (a /= 3.0) * a * a - a * b + c) / 2.0) * q + (p = b / 3.0 - a * a) * p * p) > 0.0) {
                double t = Math.sqrt(d);
                double result = Math.cbrt(-q + t) + Math.cbrt(-q - t) - a;
                if (BSplineInterpolation.rangeCheck(result)) {
                    return result;
                }
            } else if (d == 0.0) {
                double t = Math.cbrt(-q);
                double result = 2.0 * t - a;
                if (BSplineInterpolation.rangeCheck(result)) {
                    return result;
                }
                result = -t - a;
                if (BSplineInterpolation.rangeCheck(result)) {
                    return result;
                }
            } else {
                double phi = Math.acos(-q / Math.sqrt(-(p * p * p)));
                double t = Math.sqrt(-p);
                p = Math.cos(phi / 3.0);
                q = Math.sqrt(3.0 - 3.0 * p * p);
                double result = 2.0 * t * p - a;
                if (BSplineInterpolation.rangeCheck(result)) {
                    return result;
                }
                result = -t * (p + q) - a;
                if (BSplineInterpolation.rangeCheck(result)) {
                    return result;
                }
                result = -t * (p - q) - a;
                if (BSplineInterpolation.rangeCheck(result)) {
                    return result;
                }
            }
        } else if (c2 != 0.0) {
            double result;
            double b = c1 / (2.0 * c2);
            double c = c0 / c2;
            double p = b * b - c;
            if (p > 0.0) {
                double result2 = -b - (p = Math.sqrt(p));
                if (BSplineInterpolation.rangeCheck(result2)) {
                    return result2;
                }
                result2 = -b + p;
                if (BSplineInterpolation.rangeCheck(result2)) {
                    return result2;
                }
            } else if (p == 0.0 && BSplineInterpolation.rangeCheck(result = -b)) {
                return result;
            }
        } else if (c1 != 0.0) {
            double t = c0;
            double m = c1;
            double result = -t / m;
            if (BSplineInterpolation.rangeCheck(result)) {
                return result;
            }
        } else {
            return c0;
        }
        return BSplineInterpolation.failedCalculation();
    }

    private static float calcValue(float y1, float y2, float y3, float y4, double t) {
        float c1 = 3.0f * (y2 - y1);
        float c2 = 3.0f * (y1 - 2.0f * y2 + y3);
        float c3 = y4 - y1 + 3.0f * (y2 - y3);
        float value = y1;
        double tPot = t;
        value = (float)((double)value + tPot * (double)c1);
        value = (float)((double)value + (tPot *= t) * (double)c2);
        value = (float)((double)value + (tPot *= t) * (double)c3);
        return value;
    }

    private static float failedCalculation() {
        return 0.0f;
    }

    private static boolean rangeCheck(double result) {
        double SMALL = -1.0E-10;
        return result >= SMALL && result <= 1.000001;
    }
}

