/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored;

import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.BSplineInterpolation;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.ConstantEaseIn;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.ConstantEaseOut;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.ConstantInterpolation;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.LinearInterpolation;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.client.model.ModelFormatException;
import org.lwjgl.util.vector.Vector2f;

public abstract class Spline {
    private static Map<Byte, IEaseInSplineFactory> ease_in_factories = new HashMap<Byte, IEaseInSplineFactory>();
    private static Map<Byte, IInterpolationSplineFactory> interpolation_factories = new HashMap<Byte, IInterpolationSplineFactory>();
    private static Map<Byte, IEaseOutSplineFactory> ease_out_factories = new HashMap<Byte, IEaseOutSplineFactory>();
    public static final byte EASE_IN_CONST = 0;
    public static final byte INTERPOLATION_CONST = 8;
    public static final byte INTERPOLATION_LINEAR = 9;
    public static final byte INTERPOLATION_BSPLINE = 10;
    public static final byte EASE_OUT_CONST = 16;

    public abstract boolean isInRange(float var1);

    public abstract float getValueAt(float var1);

    public static IEaseInSplineFactory registerEaseInFactory(byte descriminator, IEaseInSplineFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory can't be null");
        }
        return ease_in_factories.put(descriminator, factory);
    }

    public static Spline easeIn(byte descr, Vector2f right, DataInputStream dis) throws ModelFormatException, IOException {
        IEaseInSplineFactory factory = ease_in_factories.get(descr);
        if (factory == null) {
            throw new ModelFormatException("Unknown ease-in mode.");
        }
        return factory.newSpline(right, dis);
    }

    public static IInterpolationSplineFactory registerInterpolateFactory(byte descriminator, IInterpolationSplineFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory can't be null");
        }
        return interpolation_factories.put(descriminator, factory);
    }

    public static Spline interpolating(byte descr, Vector2f left, Vector2f right, DataInputStream dis) throws ModelFormatException, IOException {
        IInterpolationSplineFactory factory = interpolation_factories.get(descr);
        if (factory == null) {
            throw new ModelFormatException("Unknown interpolate mode.");
        }
        return factory.newSpline(left, right, dis);
    }

    public static IEaseOutSplineFactory registerEaseOutFactory(byte descriminator, IEaseOutSplineFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory can't be null");
        }
        return ease_out_factories.put(descriminator, factory);
    }

    public static Spline easeOut(byte descr, Vector2f left, DataInputStream dis) throws ModelFormatException, IOException {
        IEaseOutSplineFactory factory = ease_out_factories.get(descr);
        if (factory == null) {
            throw new ModelFormatException("Unknown ease-out mode.");
        }
        return factory.newSpline(left, dis);
    }

    public static Vector2f readPoint(DataInputStream dis) throws IOException {
        float x = dis.readFloat();
        float y = dis.readFloat();
        return new Vector2f(x, y);
    }

    static {
        Spline.registerEaseInFactory((byte)0, ConstantEaseIn.factory);
        Spline.registerInterpolateFactory((byte)8, ConstantInterpolation.factory);
        Spline.registerInterpolateFactory((byte)9, LinearInterpolation.factory);
        Spline.registerInterpolateFactory((byte)10, BSplineInterpolation.factory);
        Spline.registerEaseOutFactory((byte)16, ConstantEaseOut.factory);
    }

    public static interface IEaseOutSplineFactory {
        public Spline newSpline(Vector2f var1, DataInputStream var2) throws IOException;
    }

    public static interface IEaseInSplineFactory {
        public Spline newSpline(Vector2f var1, DataInputStream var2) throws IOException;
    }

    public static interface IInterpolationSplineFactory {
        public Spline newSpline(Vector2f var1, Vector2f var2, DataInputStream var3) throws IOException;
    }
}

