/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored;

import com.github.worldsender.mcanm.client.model.mcanmmodel.Utils;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.IAnimation;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.AnimatedTransform;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelFormatException;

public class StoredAnimation
implements IAnimation {
    public static final long MAGIC_NUMBER = 5568778193361522253L;
    private final ResourceLocation origin;
    private final Map<String, AnimatedTransform> animations;

    private static DataInputStream getStream(ResourceLocation resLoc, IResourceManager manager) throws ModelFormatException {
        if (manager == null) {
            throw new IllegalArgumentException("Manager can't be null");
        }
        try {
            return new DataInputStream(manager.func_110536_a(resLoc).func_110527_b());
        }
        catch (IOException ioe) {
            throw new ModelFormatException(String.format("Can't read from resource %s.", resLoc), (Throwable)ioe);
        }
    }

    public StoredAnimation(ResourceLocation file) throws ModelFormatException {
        this(file, Minecraft.func_71410_x().func_110442_L());
    }

    public StoredAnimation(ResourceLocation file, IResourceManager resManager) throws ModelFormatException {
        this(StoredAnimation.getStream(file, resManager), file);
    }

    public StoredAnimation(DataInputStream dis) throws ModelFormatException {
        this(dis, null);
    }

    private StoredAnimation(DataInputStream dataIn, ResourceLocation src) throws ModelFormatException {
        this.origin = src;
        this.animations = new HashMap<String, AnimatedTransform>();
        this.loadFrom(dataIn, String.valueOf(src));
    }

    private void loadFrom(DataInputStream dataIn, String origin) throws ModelFormatException {
        try (DataInputStream dis = dataIn;){
            long magic = dis.readLong();
            if (magic != 5568778193361522253L) {
                throw new ModelFormatException("Wrong magic number");
            }
            String artist = Utils.readString(dis);
            int animatedBoneCount = dis.readUnsignedByte();
            for (int i = 0; i < animatedBoneCount; ++i) {
                String boneName = Utils.readString(dis);
                AnimatedTransform boneTransform = new AnimatedTransform(dis);
                this.animations.put(boneName, boneTransform);
            }
        }
        catch (EOFException eof) {
            throw new ModelFormatException("Unexpected end of stream.", (Throwable)eof);
        }
        catch (IOException ioe) {
            throw new ModelFormatException(String.format("Error handling resource %s.", origin), (Throwable)ioe);
        }
        catch (ModelFormatException mfe) {
            throw new ModelFormatException(String.format("Model format error in resource %s.", origin), (Throwable)mfe);
        }
    }

    public void reload(IResourceManager resManager) {
        if (this.origin == null) {
            return;
        }
        this.loadFrom(StoredAnimation.getStream(this.origin, resManager), String.valueOf(this.origin));
    }

    @Override
    public IAnimation.BoneTransformation getCurrentTransformation(String bone, float frame) {
        AnimatedTransform anim = this.animations.get(bone);
        if (anim == null) {
            return null;
        }
        return anim.getTransformAt(frame);
    }

    public ResourceLocation getOrigin() {
        return this.origin;
    }
}

