/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.data;

import com.github.worldsender.mcanm.client.model.mcanmmodel.Utils;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.IAnimation;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.IModelData;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RawDataV1;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class ModelDataBasic
implements IModelData {
    protected static Minecraft mc = Minecraft.func_71410_x();
    private static Tessellator tess = Tessellator.field_78398_a;
    private final Part[] parts;
    private final Bone[] bones;

    private static int handleBone(RawDataV1.Bone[] bones, int index, List<List<Integer>> layers, List<Integer> handled) {
        if (index == 255) {
            return -1;
        }
        int parent = bones[index].parent & 0xFF;
        int layerNbr = ModelDataBasic.handleBone(bones, parent, layers, handled) + 1;
        if (handled.contains(index)) {
            return layerNbr;
        }
        handled.add(index);
        if (layers.size() <= layerNbr) {
            layers.add(new ArrayList());
        }
        List<Integer> layer = layers.get(layerNbr);
        layer.add(index);
        return layerNbr;
    }

    private static int[] breadthFirst(RawDataV1.Bone[] src) {
        ArrayList<List<Integer>> layers = new ArrayList<List<Integer>>();
        ArrayList<Integer> handled = new ArrayList<Integer>();
        for (int i = 0; i < src.length; ++i) {
            ModelDataBasic.handleBone(src, i, layers, handled);
        }
        int[] breadthFirst = new int[src.length];
        int i = 0;
        for (List list : layers) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int b = (Integer)iterator.next();
                breadthFirst[i++] = b;
            }
        }
        return breadthFirst;
    }

    public ModelDataBasic(RawDataV1 data) {
        int i;
        Part[] parts = new Part[data.parts.length];
        Bone[] bones = new Bone[data.bones.length];
        int[] breadthOrder = ModelDataBasic.breadthFirst(data.bones);
        Bone[] breadthFirst = new Bone[data.bones.length];
        for (i = 0; i < breadthOrder.length; ++i) {
            Bone newBone;
            int idx = breadthOrder[i];
            RawDataV1.Bone bone = data.bones[idx];
            bones[idx] = newBone = Bone.fromData(bone, bones);
            breadthFirst[i] = newBone;
        }
        for (i = 0; i < data.parts.length; ++i) {
            parts[i] = new Part(data.parts[i], bones);
        }
        this.bones = breadthFirst;
        this.parts = parts;
    }

    private void setupBones(IAnimation anim, float frame) {
        for (Bone bone : this.bones) {
            bone.setTransformation(anim, frame);
        }
    }

    @Override
    public void renderAll(IAnimation currAnimation, float frame) {
        this.setupBones(currAnimation, frame);
        tess.func_78371_b(4);
        for (Part part : this.parts) {
            part.render();
        }
        tess.func_78381_a();
    }

    @Override
    public void renderFiltered(Predicate<String> filter, IAnimation currAnimation, float frame) {
        this.setupBones(currAnimation, frame);
        tess.func_78371_b(4);
        for (Part part : this.parts) {
            if (!filter.apply((Object)part.getName())) continue;
            part.render();
        }
        tess.func_78381_a();
    }

    private static class Bone {
        private static final Matrix4f identity = new Matrix4f();
        protected final Matrix4f localToParent;
        protected final Matrix4f parentToLocal;
        public final String name;
        protected Matrix4f transformed = new Matrix4f();
        protected Matrix4f transformedGlobalToGlobal = new Matrix4f();
        protected Matrix4f transformedGlobalToGlobalIT = new Matrix4f();

        protected Bone(Matrix4f localMatrix, String name) {
            this.localToParent = localMatrix;
            this.parentToLocal = Matrix4f.invert((Matrix4f)localMatrix, null);
            this.name = name;
        }

        public Vector4f getHead() {
            Matrix4f localToGlobal = this.localToGlobal(identity, null);
            Vector4f head = new Vector4f();
            head.y = 1.0f;
            head.w = 1.0f;
            Matrix4f.transform((Matrix4f)localToGlobal, (Vector4f)head, (Vector4f)head);
            return head;
        }

        public Vector4f getTail() {
            Matrix4f localToGlobal = this.localToGlobal(identity, null);
            Vector4f head = new Vector4f();
            head.w = 1.0f;
            Matrix4f.transform((Matrix4f)localToGlobal, (Vector4f)head, (Vector4f)head);
            return head;
        }

        private void resetTransform() {
            Matrix4f.load((Matrix4f)identity, (Matrix4f)this.transformed);
            Matrix4f.load((Matrix4f)identity, (Matrix4f)this.transformedGlobalToGlobal);
            Matrix4f.load((Matrix4f)identity, (Matrix4f)this.transformedGlobalToGlobalIT);
        }

        public void setTransformation(IAnimation anim, float frame) {
            if (anim == null) {
                this.resetTransform();
                return;
            }
            IAnimation.BoneTransformation btr = anim.getCurrentTransformation(this.name, frame);
            if (btr == null) {
                this.resetTransform();
                return;
            }
            Matrix4f worldToLocal = this.globalToLocal(identity, null);
            Matrix4f.load((Matrix4f)btr.asMatrix(), (Matrix4f)this.transformed);
            Matrix4f transformedLocalToWorld = this.localToGlobal(identity, null);
            Matrix4f.mul((Matrix4f)transformedLocalToWorld, (Matrix4f)worldToLocal, (Matrix4f)this.transformedGlobalToGlobal);
            Matrix4f.load((Matrix4f)this.transformedGlobalToGlobal, (Matrix4f)this.transformedGlobalToGlobalIT);
            this.transformedGlobalToGlobalIT.invert().transpose();
        }

        protected Matrix4f globalToLocal(Matrix4f src, Matrix4f dest) {
            return Matrix4f.mul((Matrix4f)this.parentToLocal, (Matrix4f)src, (Matrix4f)dest);
        }

        protected Matrix4f localToGlobal(Matrix4f src, Matrix4f dest) {
            dest = Matrix4f.mul((Matrix4f)this.transformed, (Matrix4f)src, (Matrix4f)dest);
            return Matrix4f.mul((Matrix4f)this.localToParent, (Matrix4f)dest, (Matrix4f)dest);
        }

        public Matrix4f getTransformGlobal() {
            return this.transformedGlobalToGlobal;
        }

        public Matrix4f getTransformGlobalIT() {
            return this.transformedGlobalToGlobalIT;
        }

        public static Bone fromData(RawDataV1.Bone data, Bone[] allBones) {
            Matrix4f localToParent = Utils.fromRotTrans(data.rotation, data.offset, 1.0f);
            if (data.parent != -1) {
                return new ParentedBone(localToParent, data.name, allBones[data.parent & 0xFF]);
            }
            return new Bone(localToParent, data.name);
        }

        private static class ParentedBone
        extends Bone {
            private Bone parent;

            protected ParentedBone(Matrix4f localToParent, String name, Bone parent) {
                super(localToParent, name);
                this.parent = Objects.requireNonNull(parent, String.format("Parent of bone %s can't be null", this.name));
            }

            @Override
            protected Matrix4f globalToLocal(Matrix4f src, Matrix4f dest) {
                dest = this.parent.globalToLocal(src, dest);
                return super.globalToLocal(dest, dest);
            }

            @Override
            protected Matrix4f localToGlobal(Matrix4f src, Matrix4f dest) {
                dest = super.localToGlobal(src, dest);
                return this.parent.localToGlobal(dest, dest);
            }
        }
    }

    private static class Part {
        private final Point[] pointsList;
        private final ResourceLocation resLocation;
        private final short[] indices;
        private final String name;

        public Part(RawDataV1.ModelPart data, Bone[] bones) {
            Point[] points = new Point[data.points.length];
            int idx = 0;
            for (RawDataV1.TesselationPoint point : data.points) {
                points[idx++] = Point.from(point, bones);
            }
            this.pointsList = points;
            this.resLocation = new ResourceLocation(data.material.resLocationRaw);
            this.indices = Arrays.copyOf(data.indices, data.indices.length);
            this.name = data.name;
        }

        public void render() {
            ModelDataBasic.mc.field_71446_o.func_110577_a(this.resLocation);
            for (short idx : this.indices) {
                this.pointsList[idx & 0xFFFF].render();
            }
        }

        public String getName() {
            return this.name;
        }

        private static class BoundPoint
        extends Point {
            private List<Binding> binds = new ArrayList<Binding>();

            public BoundPoint(Vector3f pos, Vector3f norm, Vector2f uv, RawDataV1.BoneBinding[] readBinds, Bone[] bones) {
                super(pos, norm, uv);
                float strengthSummed = 0.0f;
                for (RawDataV1.BoneBinding bind : readBinds) {
                    if (bind.bindingValue <= 0.0f) continue;
                    this.binds.add(new Binding(bones[bind.boneIndex & 0xFF], bind.bindingValue));
                    strengthSummed += bind.bindingValue;
                }
                for (Binding bind : this.binds) {
                    bind.normalize(strengthSummed);
                }
            }

            @Override
            public void render() {
                Point.Vertex base = this.vert;
                Point.Vertex transformed = null;
                for (Binding bind : this.binds) {
                    transformed = bind.addTransformed(base, transformed);
                }
                transformed.setUV(this.vert.uv);
                transformed.render();
            }

            private static class Binding {
                private static Vector4f posBuff = new Vector4f();
                private static Vector4f normBuff = new Vector4f();
                private Bone bone;
                private float strength;

                public Binding(Bone bone, float strenght) {
                    this.bone = bone;
                    this.strength = strenght;
                }

                public Point.Vertex addTransformed(Point.Vertex base, Point.Vertex trgt) {
                    Objects.requireNonNull(base);
                    posBuff.set(((Point.Vertex)base).pos.x, ((Point.Vertex)base).pos.y, ((Point.Vertex)base).pos.z, 1.0f);
                    normBuff.set(((Point.Vertex)base).norm.x, ((Point.Vertex)base).norm.y, ((Point.Vertex)base).norm.z, 0.0f);
                    Matrix4f globalTransform = this.bone.getTransformGlobal();
                    Matrix4f globalTransformIT = this.bone.getTransformGlobalIT();
                    Matrix4f.transform((Matrix4f)globalTransform, (Vector4f)posBuff, (Vector4f)posBuff);
                    Matrix4f.transform((Matrix4f)globalTransformIT, (Vector4f)normBuff, (Vector4f)normBuff);
                    Vector4f position = new Vector4f((ReadableVector4f)posBuff);
                    Vector3f normal = new Vector3f(Binding.normBuff.x, Binding.normBuff.y, Binding.normBuff.z);
                    position.scale(this.strength);
                    normal.scale(this.strength);
                    if (trgt == null) {
                        trgt = new Point.Vertex(position, normal, null);
                    } else {
                        trgt.offset(position);
                        trgt.addNormal(normal);
                    }
                    return trgt;
                }

                public void normalize(float sum) {
                    this.strength /= sum;
                }
            }
        }

        private static class Point {
            protected final Vertex vert;

            protected Point(Vector3f pos, Vector3f norm, Vector2f uv) {
                this.vert = new Vertex(new Vector4f(pos.x, pos.y, pos.z, 1.0f), norm, uv);
            }

            public void render() {
                this.vert.render();
            }

            public static Point from(RawDataV1.TesselationPoint data, Bone[] bones) {
                boolean isBound;
                boolean bl = isBound = data.boneBindings.length > 0;
                if (isBound) {
                    return new BoundPoint(data.coords, data.normal, data.texCoords, data.boneBindings, bones);
                }
                return new Point(data.coords, data.normal, data.texCoords);
            }

            protected static class Vertex {
                private Vector4f pos;
                private Vector3f norm;
                private Vector2f uv;

                public Vertex(Vector4f pos, Vector3f norm, Vector2f uv) {
                    if (pos == null) {
                        pos = new Vector4f();
                    }
                    if (norm == null) {
                        norm = new Vector3f();
                    }
                    if (uv == null) {
                        uv = new Vector2f();
                    }
                    this.pos = pos;
                    this.norm = norm;
                    this.uv = uv;
                }

                public void render() {
                    tess.func_78375_b(this.norm.x, this.norm.z, -this.norm.y);
                    tess.func_78385_a((double)this.uv.x, (double)this.uv.y);
                    tess.func_78377_a((double)(this.pos.x / this.pos.w), (double)(this.pos.z / this.pos.w), (double)(-this.pos.y / this.pos.w));
                }

                public void offset(Vector4f vector) {
                    this.pos = Vector4f.add((Vector4f)this.pos, (Vector4f)vector, (Vector4f)this.pos);
                }

                public void addNormal(Vector3f normal) {
                    Vector3f.add((Vector3f)this.norm, (Vector3f)normal, (Vector3f)this.norm);
                }

                public void setUV(Vector2f uv) {
                    this.uv = uv;
                }
            }
        }
    }
}

