/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.loader;

import com.github.worldsender.mcanm.client.model.mcanmmodel.Utils;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RawData;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RawDataV1;
import com.github.worldsender.mcanm.client.model.mcanmmodel.loader.VersionizedModelLoader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import net.minecraftforge.client.model.ModelFormatException;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class LoaderVersion1
extends VersionizedModelLoader {
    public static final LoaderVersion1 instance = new LoaderVersion1();

    @Override
    public RawDataV1 loadFromInputStream(RawData meta, int version, DataInputStream di) throws IOException {
        int nbrBones;
        RawDataV1.Header header = new RawDataV1.Header();
        int nbrParts = di.readUnsignedByte();
        header.nbrBones = nbrBones = di.readUnsignedByte();
        header.nbrParts = nbrParts;
        RawDataV1.ModelPart[] parts = new RawDataV1.ModelPart[nbrParts];
        TreeSet<String> partsNameSet = new TreeSet<String>();
        int i = 0;
        while (i < nbrParts) {
            RawDataV1.ModelPart newPart = this.readPartFrom(di, header);
            if (!partsNameSet.add(newPart.name)) {
                throw new ModelFormatException("Two parts with same name " + newPart.name);
            }
            parts[i++] = newPart;
        }
        RawDataV1.Bone[] bones = new RawDataV1.Bone[nbrBones];
        TreeSet<String> boneNameSet = new TreeSet<String>();
        int i2 = 0;
        while (i2 < nbrBones) {
            RawDataV1.Bone newBone = this.readBoneFrom(di, header);
            if (!boneNameSet.add(newBone.name)) {
                throw new ModelFormatException("Two bones with same name " + newBone.name);
            }
            bones[i2++] = newBone;
        }
        this.readBoneParents(di, bones);
        return new RawDataV1(meta, parts, bones);
    }

    protected void readBoneParents(DataInputStream di, RawDataV1.Bone[] bones) throws EOFException, IOException {
        int nbrBones = bones.length;
        for (RawDataV1.Bone bone : bones) {
            int parentIndex = di.readUnsignedByte();
            if (parentIndex != 255 && parentIndex >= nbrBones) {
                throw new ModelFormatException(String.format("ParentIndex (%d) has to be smaller than nbrBones (%d).", parentIndex, nbrBones));
            }
            bone.parent = (byte)parentIndex;
        }
    }

    protected RawDataV1.Bone readBoneFrom(DataInputStream di, RawDataV1.Header header) throws EOFException, IOException {
        RawDataV1.Bone bone = new RawDataV1.Bone();
        String name = Utils.readString(di);
        Quaternion quat = Utils.readQuat(di);
        Vector3f offset = Utils.readVector3f(di);
        bone.name = name;
        bone.rotation = quat;
        bone.offset = offset;
        return bone;
    }

    protected RawDataV1.ModelPart readPartFrom(DataInputStream di, RawDataV1.Header header) throws EOFException, IOException {
        RawDataV1.ModelPart mp = new RawDataV1.ModelPart();
        int nbrPoints = di.readUnsignedShort();
        int nbrIndices = di.readUnsignedShort() * 3;
        String name = Utils.readString(di);
        RawDataV1.Material material = this.readMaterialFrom(di, header);
        RawDataV1.TesselationPoint[] vertexArray = new RawDataV1.TesselationPoint[nbrPoints];
        int i = 0;
        while (i < nbrPoints) {
            vertexArray[i++] = this.readPointFrom(di, header);
        }
        short[] indexArray = new short[nbrIndices];
        for (int i2 = 0; i2 < nbrIndices; ++i2) {
            int candidate = di.readUnsignedShort();
            if (candidate >= nbrPoints) {
                throw new ModelFormatException(String.format("Vertexindex (%d) has to be smaller than nbrPoints (%d).", candidate, nbrPoints));
            }
            indexArray[i2] = (short)candidate;
        }
        mp.name = name;
        mp.material = material;
        mp.points = vertexArray;
        mp.indices = indexArray;
        return mp;
    }

    protected RawDataV1.Material readMaterialFrom(DataInputStream di, RawDataV1.Header header) throws EOFException, IOException {
        RawDataV1.Material tex = new RawDataV1.Material();
        tex.resLocationRaw = Utils.readString(di);
        return tex;
    }

    protected RawDataV1.TesselationPoint readPointFrom(DataInputStream di, RawDataV1.Header header) throws EOFException, IOException {
        RawDataV1.TesselationPoint tessP = new RawDataV1.TesselationPoint();
        Vector3f coords = Utils.readVector3f(di);
        Vector3f normal = Utils.readVector3f(di);
        if (normal.length() == 0.0f) {
            throw new ModelFormatException("Normal vector can't have zerolength.");
        }
        Vector2f texCoords = Utils.readVector2f(di);
        RawDataV1.BoneBinding[] bindings = this.readBoneBindingsFrom(di, header);
        tessP.coords = coords;
        tessP.normal = normal;
        tessP.texCoords = texCoords;
        tessP.boneBindings = bindings;
        return tessP;
    }

    protected RawDataV1.BoneBinding[] readBoneBindingsFrom(DataInputStream di, RawDataV1.Header header) throws EOFException, IOException {
        int bindIndex;
        RawDataV1.BoneBinding[] bindings = new RawDataV1.BoneBinding[4];
        int i = 0;
        while (i < 4 && (bindIndex = di.readUnsignedByte()) != 255) {
            RawDataV1.BoneBinding binding = new RawDataV1.BoneBinding();
            if (bindIndex >= header.nbrBones) {
                throw new ModelFormatException("Can't bind to non-existant bone.");
            }
            float bindingValue = di.readFloat();
            if (Math.abs(bindingValue) > 100.0f) {
                throw new ModelFormatException(String.format("Value for binding seems out of range: %f", Float.valueOf(bindingValue)));
            }
            binding.boneIndex = (byte)bindIndex;
            binding.bindingValue = bindingValue;
            bindings[i++] = binding;
        }
        return Arrays.copyOf(bindings, i);
    }
}

