/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.mcanmmodel.loader;

import com.github.worldsender.mcanm.client.model.mcanmmodel.Utils;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RawData;
import com.github.worldsender.mcanm.client.model.mcanmmodel.loader.LoaderVersion1;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelFormatException;

public abstract class VersionizedModelLoader {
    public static final long magic = 5568778193362306124L;
    private static Map<Integer, VersionizedModelLoader> registeredLoaders = new HashMap<Integer, VersionizedModelLoader>();

    public static boolean registerLoader(int version, VersionizedModelLoader vml) {
        return registeredLoaders.put(version, vml) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RawData loadVersionized(ResourceLocation resLocation, IResourceManager resourceManager) throws ModelFormatException {
        if (resourceManager == null) {
            throw new IllegalArgumentException("Resource-Manager can't be null.");
        }
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(resourceManager.func_110536_a(resLocation).func_110527_b()));){
            RawData rawData = VersionizedModelLoader.loadFromStream(dis, resLocation, resLocation.toString());
            return rawData;
        }
        catch (IOException ioe) {
            throw new ModelFormatException(String.format("Can't open resource %s", resLocation), (Throwable)ioe);
        }
    }

    public static RawData loadVersionized(DataInputStream dis, String filename) throws ModelFormatException {
        if (dis == null) {
            throw new IllegalArgumentException("DataInputStream can not be null");
        }
        return VersionizedModelLoader.loadFromStream(dis, null, filename);
    }

    private static RawData loadFromStream(DataInputStream dis, ResourceLocation originalLocation, String streamName) throws ModelFormatException {
        try {
            long foundMagic = dis.readLong();
            if (foundMagic != 5568778193362306124L) {
                throw new ModelFormatException(String.format("Wrong magic number. Found %x, expected %x.", foundMagic, 5568778193362306124L));
            }
            UUID uuid = new UUID(dis.readLong(), dis.readLong());
            String artist = Utils.readString(dis);
            int version = dis.readInt();
            VersionizedModelLoader loader = registeredLoaders.get(version);
            if (loader == null) {
                throw new ModelFormatException("Unrecognized model version.");
            }
            RawData meta = new RawData(uuid, artist, originalLocation);
            RawData data = loader.loadFromInputStream(meta, version, dis);
            return data;
        }
        catch (EOFException eofe) {
            throw new ModelFormatException(String.format("Unexpected end of file (%s).", streamName), (Throwable)eofe);
        }
        catch (IOException ioe) {
            throw new ModelFormatException(String.format("Can't read from stream given (%s).", streamName), (Throwable)ioe);
        }
        catch (ModelFormatException mfe) {
            throw new ModelFormatException(String.format("Model format exception in %s", streamName), (Throwable)mfe);
        }
    }

    public abstract RawData loadFromInputStream(RawData var1, int var2, DataInputStream var3) throws IOException, ModelFormatException;

    static {
        VersionizedModelLoader.registerLoader(1, LoaderVersion1.instance);
    }
}

