/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.util;

import com.github.worldsender.mcanm.MCAnm;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.IAnimation;
import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.stored.StoredAnimation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelFormatException;

public class AnimationLoader
implements IResourceManagerReloadListener {
    public static final AnimationLoader instance = new AnimationLoader();
    private Map<ResourceLocation, StoredAnimation> registry = new HashMap<ResourceLocation, StoredAnimation>();

    public static StoredAnimation loadAnimation(ResourceLocation resLoc) {
        return instance.loadAnimation(resLoc, Minecraft.func_71410_x().func_110442_L());
    }

    public static IAnimation loadAnimation(String string) {
        return AnimationLoader.loadAnimation(new ResourceLocation(string));
    }

    public StoredAnimation loadAnimation(ResourceLocation resLoc, IResourceManager resManager) {
        try {
            StoredAnimation registeredAnim = this.registry.get(resLoc);
            if (registeredAnim != null) {
                return registeredAnim;
            }
            StoredAnimation newAnim = new StoredAnimation(resLoc, resManager);
            this.registry.put(resLoc, newAnim);
            return newAnim;
        }
        catch (ModelFormatException mfe) {
            MCAnm.logger.error(String.format("Error loading animation %s", resLoc), (Throwable)mfe);
            return null;
        }
    }

    public boolean registerAnimation(StoredAnimation animation) {
        if (animation == null) {
            throw new IllegalArgumentException("Animation can't be null");
        }
        if (animation.getOrigin() == null) {
            throw new IllegalArgumentException("The animation has to be loaded from a ResourceLocation.");
        }
        if (this.registry.containsKey(animation.getOrigin())) {
            this.registry.put(animation.getOrigin(), animation);
            return true;
        }
        return false;
    }

    public void func_110549_a(IResourceManager resManager) {
        if (!MCAnm.enableReload.getBoolean()) {
            return;
        }
        for (StoredAnimation anim : this.registry.values()) {
            anim.reload(resManager);
        }
    }
}

