/*
 * Decompiled with CFR 0.152.
 */
package com.github.worldsender.mcanm.client.model.util;

import com.github.worldsender.mcanm.MCAnm;
import com.github.worldsender.mcanm.client.model.mcanmmodel.MCMDModelLoader;
import com.github.worldsender.mcanm.client.model.mcanmmodel.ModelMCMD;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class ModelLoader
implements IResourceManagerReloadListener {
    public static final ModelLoader instance = new ModelLoader();
    private static final Logger logger = MCAnm.logger;
    private HashMap<ResourceLocation, ModelMCMD> cachedModels = new HashMap();
    private IResourceManager currentManager = Minecraft.func_71410_x().func_110442_L();

    public static ModelMCMD loadFrom(ResourceLocation resLoc) {
        return instance.loadModelFrom(resLoc);
    }

    public static ModelMCMD loadFrom(String resLoc) {
        return instance.loadModelFrom(resLoc);
    }

    public void func_110549_a(IResourceManager reloadManager) {
        if (!MCAnm.enableReload.getBoolean()) {
            return;
        }
        this.currentManager = reloadManager;
        for (Map.Entry<ResourceLocation, ModelMCMD> entry : this.cachedModels.entrySet()) {
            entry.getValue().reload(reloadManager);
        }
    }

    public boolean registerModel(ModelMCMD model) {
        if (model == null) {
            throw new IllegalArgumentException("Model can't be null");
        }
        ResourceLocation resLoc = model.getResourceLocation();
        if (resLoc == null) {
            throw new IllegalArgumentException("The model you are trying to register has not been loaded from a valid ResourceLocation.");
        }
        if (this.cachedModels.containsKey(resLoc)) {
            return false;
        }
        this.cachedModels.put(resLoc, model);
        return true;
    }

    public ModelMCMD loadModelFrom(ResourceLocation resLocation) {
        ModelMCMD model = this.cachedModels.get(resLocation);
        if (model == null) {
            logger.trace(String.format("[ModelLoader] Loading new model from %s", resLocation));
            model = MCMDModelLoader.instance.loadInstance(resLocation, this.currentManager, false);
            boolean registered = this.registerModel(model);
            assert (registered);
        } else {
            logger.trace(String.format("[ModelLoader] Loading cached model from %s", resLocation));
        }
        return model;
    }

    public ModelMCMD loadModelFrom(String resLocation) {
        return this.loadModelFrom(new ResourceLocation(resLocation));
    }
}

