/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry.contact;

import java.util.Iterator;
import jinngine.geometry.Material;
import jinngine.geometry.Sphere;
import jinngine.geometry.contact.ContactGenerator;
import jinngine.math.Vector3;

public class SphereContactGenerator
implements ContactGenerator {
    private final ContactGenerator.ContactPoint cp = new ContactGenerator.ContactPoint();
    private final Sphere s1;
    private final Sphere s2;
    private boolean incontact = false;
    private final double envelope = 0.125;
    private final double shell = 0.09375;
    private final double restitution;
    private final double friction;

    public SphereContactGenerator(Sphere a, Sphere b) {
        this.s1 = a;
        this.s2 = b;
        if (a instanceof Material && b instanceof Material) {
            double ea = a.getRestitution();
            double fa = a.getFrictionCoefficient();
            double eb = b.getRestitution();
            double fb = b.getFrictionCoefficient();
            this.restitution = ea > eb ? eb : ea;
            this.friction = fa > fb ? fb : fa;
        } else if (a instanceof Material) {
            this.restitution = a.getRestitution();
            this.friction = a.getFrictionCoefficient();
        } else if (b instanceof Material) {
            this.restitution = b.getRestitution();
            this.friction = b.getFrictionCoefficient();
        } else {
            this.restitution = 0.7;
            this.friction = 0.5;
        }
        this.cp.restitution = this.restitution;
        this.cp.friction = this.friction;
    }

    @Override
    public Iterator<ContactGenerator.ContactPoint> getContacts() {
        return new Iterator<ContactGenerator.ContactPoint>(){
            boolean done = false;

            @Override
            public boolean hasNext() {
                return !this.done && SphereContactGenerator.this.incontact;
            }

            @Override
            public ContactGenerator.ContactPoint next() {
                this.done = true;
                return SphereContactGenerator.this.cp;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void run() {
        Vector3 caw = this.s1.getTransform().multiply(Vector3.zero);
        Vector3 cbw = this.s2.getTransform().multiply(Vector3.zero);
        Vector3 normal = caw.minus(cbw).normalize();
        this.cp.normal.assign(normal);
        this.cp.paw.assign(normal.multiply(-this.s1.getRadius()).add(caw));
        this.cp.pbw.assign(normal.multiply(this.s2.getRadius()).add(cbw));
        this.cp.point.assign(this.cp.paw.add(this.cp.pbw).multiply(0.5));
        double d = caw.minus(cbw).norm() - (this.s1.getRadius() + this.s2.getRadius());
        if (d >= 0.0 && d < 0.125) {
            this.cp.depth = 0.09375 - d;
            this.incontact = true;
            return;
        }
        if (d < 0.0) {
            this.cp.depth = 0.09375 - d;
            this.incontact = true;
            return;
        }
        this.cp.depth = 0.0;
        this.incontact = false;
    }

    @Override
    public void remove() {
    }
}

