/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry.contact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jinngine.collision.GJK;
import jinngine.collision.RayCast;
import jinngine.geometry.Geometry;
import jinngine.geometry.Material;
import jinngine.geometry.SupportMap3;
import jinngine.geometry.contact.ContactGenerator;
import jinngine.geometry.util.ORourke;
import jinngine.math.Matrix3;
import jinngine.math.Vector3;
import jinngine.util.GramSchmidt;

public class SupportMapContactGenerator
implements ContactGenerator {
    private final SupportMap3 Sa;
    private final SupportMap3 Sb;
    private final Geometry ga;
    private final Geometry gb;
    private final Vector3 pa = new Vector3();
    private final Vector3 pb = new Vector3();
    private final Vector3 v = new Vector3();
    private final Vector3 n = new Vector3();
    private final List<ContactGenerator.ContactPoint> contacts = new LinkedList<ContactGenerator.ContactPoint>();
    private final List<Vector3> faceA = new ArrayList<Vector3>();
    private final List<Vector3> faceB = new ArrayList<Vector3>();
    private final Vector3 gadisp = new Vector3();
    private final Vector3 gbdisp = new Vector3();
    private final double epsilon = 1.0E-7;
    private final double envelope;
    private final double shell;
    private double restitution;
    private double friction;
    private final GJK gjk = new GJK();
    private final RayCast raycast = new RayCast();

    public SupportMapContactGenerator(SupportMap3 sa, Geometry ga, SupportMap3 sb, Geometry gb) {
        this.Sa = sa;
        this.Sb = sb;
        this.ga = ga;
        this.gb = gb;
        if (gb.getEnvelope() > ga.getEnvelope()) {
            this.envelope = gb.getEnvelope();
            this.shell = this.envelope * 0.5;
        } else {
            this.envelope = ga.getEnvelope();
            this.shell = this.envelope * 0.5;
        }
    }

    @Override
    public Iterator<ContactGenerator.ContactPoint> getContacts() {
        return this.contacts.iterator();
    }

    @Override
    public void run() {
        if (this.ga instanceof Material && this.gb instanceof Material) {
            double ea = ((Material)((Object)this.ga)).getRestitution();
            double fa = ((Material)((Object)this.ga)).getFrictionCoefficient();
            double eb = ((Material)((Object)this.gb)).getRestitution();
            double fb = ((Material)((Object)this.gb)).getFrictionCoefficient();
            this.restitution = ea > eb ? eb : ea;
            this.friction = fa > fb ? fb : fa;
        } else if (this.ga instanceof Material) {
            this.restitution = ((Material)((Object)this.ga)).getRestitution();
            this.friction = ((Material)((Object)this.ga)).getFrictionCoefficient();
        } else if (this.gb instanceof Material) {
            this.restitution = ((Material)((Object)this.gb)).getRestitution();
            this.friction = ((Material)((Object)this.gb)).getFrictionCoefficient();
        } else {
            this.restitution = 0.7;
            this.friction = 0.5;
        }
        this.gjk.run(this.Sa, this.Sb, this.pa, this.pb, this.envelope, 1.0E-7, 32);
        this.v.assign(this.pa.minus(this.pb));
        this.n.assign(this.v.normalize());
        double d = this.v.squaredNorm();
        if (d < 9.999999999999998E-15 || this.gjk.getState().simplexSize > 3) {
            this.ga.getLocalTranslation(this.gadisp);
            this.gb.getLocalTranslation(this.gbdisp);
            Matrix3.multiply(this.ga.getBody().state.rotation, this.gadisp, this.gadisp);
            Matrix3.multiply(this.gb.getBody().state.rotation, this.gbdisp, this.gbdisp);
            Vector3 direction = this.ga.getBody().getPosition().add(this.gadisp).minus(this.gb.getBody().getPosition().add(this.gbdisp));
            Vector3 sp = this.Sa.supportPoint(direction.negate()).minus(this.Sb.supportPoint(direction));
            double lambda = direction.dot(sp) / direction.dot(direction) - this.envelope / direction.norm();
            this.raycast.run(this.Sa, this.Sb, new Vector3(), direction, this.pa, this.pb, lambda, this.envelope, 1.0E-7);
            this.generate2(this.pa, this.pb, this.pa.minus(this.pb).normalize());
        } else if (d > 9.999999999999998E-15 && d < this.envelope * this.envelope) {
            this.generate2(this.pa, this.pb, this.pa.minus(this.pb).normalize());
        } else {
            this.contacts.clear();
        }
    }

    private final void generate2(Vector3 a, Vector3 b, Vector3 v) {
        this.contacts.clear();
        this.faceA.clear();
        this.faceB.clear();
        this.Sa.supportFeature(v.multiply(-1.0), 0.09, this.faceA);
        this.Sb.supportFeature(v.multiply(1.0), 0.09, this.faceB);
        Collections.reverse(this.faceA);
        final Vector3 direction = v.normalize();
        final Vector3 midpoint = a.add(b).multiply(0.5);
        Matrix3 M = GramSchmidt.run(direction);
        final Matrix3 B = new Matrix3(M.column(1), M.column(2), M.column(0));
        Matrix3 Binv = B.transpose();
        ORourke.ResultHandler handler = new ORourke.ResultHandler(){

            @Override
            public final void intersection(Vector3 p, Vector3 q) {
                ContactGenerator.ContactPoint cp = new ContactGenerator.ContactPoint();
                cp.b1 = SupportMapContactGenerator.this.ga.getBody();
                cp.b2 = SupportMapContactGenerator.this.gb.getBody();
                cp.normal.assign(direction);
                cp.point.assign(B.multiply(new Vector3(p.x, p.y, 0.0)).add(midpoint));
                cp.distance = p.z - q.z;
                if (cp.distance < SupportMapContactGenerator.this.envelope) {
                    cp.depth = SupportMapContactGenerator.this.shell - cp.distance;
                    cp.envelope = SupportMapContactGenerator.this.envelope;
                    cp.restitution = SupportMapContactGenerator.this.restitution;
                    cp.friction = SupportMapContactGenerator.this.friction;
                    SupportMapContactGenerator.this.contacts.add(cp);
                }
            }
        };
        for (Vector3 p : this.faceA) {
            p.assign(Binv.multiply(p.minus(midpoint)));
        }
        for (Vector3 p : this.faceB) {
            p.assign(Binv.multiply(p.minus(midpoint)));
        }
        ORourke.run(this.faceA, this.faceB, handler);
    }

    private final void generate(Vector3 a, Vector3 b, Vector3 v) {
        ContactGenerator.ContactPoint cp;
        Vector3 cr;
        Vector3 p2tp;
        Vector3 pptp;
        Vector3 pp;
        boolean inside;
        Vector3 p1tp;
        double firstsign;
        Vector3 facenormal;
        this.contacts.clear();
        this.faceA.clear();
        this.faceB.clear();
        this.Sa.supportFeature(v.multiply(-1.0), 0.09, this.faceA);
        this.Sb.supportFeature(v.multiply(1.0), 0.09, this.faceB);
        Vector3 direction = v.normalize();
        Vector3 midpoint = a.add(b).multiply(0.5);
        Vector3 v1 = direction.copy();
        Vector3 v2 = Vector3.i;
        Vector3 v3 = Vector3.k;
        Vector3 t1 = v1.normalize();
        Vector3 t2 = v2.minus(t1.multiply(t1.dot(v2)));
        if (t2.abs().lessThan(Vector3.epsilon)) {
            v2 = Vector3.j;
            v3 = Vector3.k;
            t2 = v2.minus(t1.multiply(t1.dot(v2))).normalize();
        } else {
            t2 = t2.normalize();
        }
        if (v1.cross(v3).abs().lessThan(Vector3.epsilon)) {
            v3 = Vector3.j;
        }
        Vector3 t3 = v3.minus(t1.multiply(t1.dot(v3)).minus(t2.multiply(t2.dot(v3)))).normalize();
        Matrix3 S = new Matrix3(t1, t2, t3);
        Matrix3 Si = S.transpose();
        if (this.faceB.size() > 2) {
            facenormal = this.faceB.get(0).minus(this.faceB.get(1)).cross(this.faceB.get(2).minus(this.faceB.get(1))).normalize();
            for (Vector3 paw : this.faceA) {
                double t;
                firstsign = 0.0;
                p1tp = Si.multiply(paw.minus(midpoint));
                p1tp.x = 0.0;
                inside = true;
                pp = this.faceB.get(this.faceB.size() - 1).copy();
                for (Vector3 p2 : this.faceB) {
                    pptp = Si.multiply(pp.minus(midpoint));
                    pptp.x = 0.0;
                    p2tp = Si.multiply(p2.minus(midpoint));
                    p2tp.x = 0.0;
                    cr = p1tp.minus(pptp).cross(p2tp.minus(pptp));
                    if (firstsign == 0.0) {
                        firstsign = cr.x;
                    }
                    if (Math.signum(cr.x) != Math.signum(firstsign)) {
                        inside = false;
                        break;
                    }
                    pp = p2;
                }
                if (!inside) continue;
                cp = new ContactGenerator.ContactPoint();
                cp.restitution = this.restitution;
                cp.friction = this.friction;
                cp.b1 = this.ga.getBody();
                cp.b2 = this.gb.getBody();
                cp.distance = t = -pp.minus(paw).dot(facenormal) / direction.dot(facenormal);
                Vector3 pbw = direction.multiply(t).add(paw);
                if (!(cp.distance < this.envelope)) continue;
                cp.depth = this.shell - cp.distance;
                cp.envelope = this.envelope;
                cp.paw.assign(paw);
                cp.pbw.assign(pbw);
                cp.point.assign(S.multiply(p1tp).add(midpoint));
                cp.normal.assign(direction);
                this.contacts.add(cp);
            }
        }
        if (this.faceA.size() > 2) {
            facenormal = this.faceA.get(0).minus(this.faceA.get(1)).cross(this.faceA.get(2).minus(this.faceA.get(1))).normalize();
            for (Vector3 p1 : this.faceB) {
                double t;
                firstsign = 0.0;
                p1tp = Si.multiply(p1.minus(midpoint));
                p1tp.x = 0.0;
                inside = true;
                pp = this.faceA.get(this.faceA.size() - 1).copy();
                for (Vector3 p2 : this.faceA) {
                    pptp = Si.multiply(pp.minus(midpoint));
                    pptp.x = 0.0;
                    p2tp = Si.multiply(p2.minus(midpoint));
                    p2tp.x = 0.0;
                    cr = p1tp.minus(pptp).cross(p2tp.minus(pptp));
                    if (firstsign == 0.0) {
                        firstsign = cr.x;
                    }
                    if (Math.signum(cr.x) != Math.signum(firstsign)) {
                        inside = false;
                        break;
                    }
                    pp = p2;
                }
                if (!inside) continue;
                cp = new ContactGenerator.ContactPoint();
                cp.restitution = this.restitution;
                cp.friction = this.friction;
                cp.b1 = this.ga.getBody();
                cp.b2 = this.gb.getBody();
                cp.distance = t = pp.minus(p1).dot(facenormal) / direction.dot(facenormal);
                Vector3 paw = direction.multiply(t).add(p1);
                if (!(cp.distance < this.envelope)) continue;
                cp.depth = this.shell - cp.distance;
                cp.envelope = this.envelope;
                cp.paw.assign(paw);
                cp.pbw.assign(p1);
                cp.point.assign(S.multiply(p1tp).add(midpoint));
                cp.normal.assign(direction);
                this.contacts.add(cp);
            }
        }
        if (this.faceA.size() > 1 && this.faceB.size() > 1) {
            Vector3 p1p = this.faceA.get(this.faceA.size() - 1);
            for (Vector3 p1 : this.faceA) {
                Vector3 d1 = p1.minus(p1p);
                Vector3 d1t = Si.multiply(d1);
                d1t.x = 0.0;
                Vector3 p1pt = Si.multiply(p1p.minus(midpoint));
                p1pt.x = 0.0;
                Vector3 p2p = this.faceB.get(this.faceB.size() - 1);
                for (Vector3 p2 : this.faceB) {
                    Vector3 d2 = p2.minus(p2p);
                    Vector3 d2t = Si.multiply(d2);
                    d2t.x = 0.0;
                    Vector3 point = p2p.minus(p1p);
                    Vector3 pointt = Si.multiply(point);
                    pointt.x = 0.0;
                    double det = d1t.y * -d2t.z - d1t.z * -d2t.y;
                    if (Math.abs(det) > 1.0E-7) {
                        double alpha = 1.0 / det * (-d2t.z * pointt.y + d2t.y * pointt.z);
                        double beta = 1.0 / det * (-d1t.z * pointt.y + d1t.y * pointt.z);
                        if (alpha > 0.0 && alpha < 1.0 && beta > 0.0 && beta < 1.0) {
                            Vector3 pbw;
                            ContactGenerator.ContactPoint cp2 = new ContactGenerator.ContactPoint();
                            cp2.restitution = this.restitution;
                            cp2.friction = this.friction;
                            cp2.b1 = this.ga.getBody();
                            cp2.b2 = this.gb.getBody();
                            Vector3 paw = p1p.add(d1.multiply(alpha));
                            cp2.distance = paw.minus(pbw = p2p.add(d2.multiply(beta))).dot(direction);
                            double d = cp2.distance;
                            if (d < this.envelope) {
                                cp2.depth = this.shell - d;
                                cp2.envelope = this.envelope;
                                cp2.paw.assign(paw);
                                cp2.pbw.assign(pbw);
                                cp2.point.assign(S.multiply(p1pt.add(d1t.multiply(alpha))).add(midpoint));
                                cp2.normal.assign(direction);
                                this.contacts.add(cp2);
                            }
                        }
                    }
                    p2p = p2;
                }
                p1p = p1;
            }
        }
    }

    @Override
    public void remove() {
    }
}

