/*
 * Decompiled with CFR 0.152.
 */
package jinngine.math;

import jinngine.math.Matrix3;
import jinngine.math.Quaternion;
import jinngine.math.Vector3;

public class InertiaMatrix
extends Matrix3 {
    public InertiaMatrix translate(double mass, Vector3 r) {
        InertiaMatrix I = new InertiaMatrix();
        Matrix3.set(this, (Matrix3)I);
        InertiaMatrix.translate(I, mass, r);
        return I;
    }

    public static void translate(InertiaMatrix M, double mass, Vector3 r) {
        double t11 = M.a11 + mass * (r.y * r.y + r.z * r.z);
        double t22 = M.a22 + mass * (r.x * r.x + r.z * r.z);
        double t33 = M.a33 + mass * (r.x * r.x + r.y * r.y);
        double t12 = M.a12 - mass * (r.x * r.y);
        double t13 = M.a13 - mass * (r.x * r.z);
        double t23 = M.a23 - mass * (r.y * r.z);
        M.a11 = t11;
        M.a12 = t12;
        M.a13 = t13;
        M.a21 = t12;
        M.a22 = t22;
        M.a23 = t23;
        M.a31 = t13;
        M.a32 = t23;
        M.a33 = t33;
    }

    public InertiaMatrix rotate(Quaternion q) {
        InertiaMatrix I = new InertiaMatrix();
        Matrix3.set(this, (Matrix3)I);
        return InertiaMatrix.rotate(I, q);
    }

    public static InertiaMatrix rotate(InertiaMatrix M, Quaternion q) {
        Matrix3 R = q.toRotationMatrix3();
        Matrix3.multiply(R, M, (Matrix3)M);
        Matrix3.transpose(R);
        Matrix3.multiply((Matrix3)M, R, (Matrix3)M);
        return M;
    }

    public static InertiaMatrix rotate(InertiaMatrix M, Matrix3 R) {
        Matrix3.multiply(R, M, (Matrix3)M);
        Matrix3.transpose(R);
        Matrix3.multiply((Matrix3)M, R, (Matrix3)M);
        return M;
    }
}

