/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.constraint.contact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jinngine.collision.BroadphaseCollisionDetection;
import jinngine.geometry.Geometry;
import jinngine.geometry.Sphere;
import jinngine.geometry.SupportMap3;
import jinngine.geometry.contact.ContactGenerator;
import jinngine.geometry.contact.ContactGeneratorClassifier;
import jinngine.geometry.contact.SphereContactGenerator;
import jinngine.geometry.contact.SupportMapContactGenerator;
import jinngine.geometry.contact.SupportMapSphereContactGenerator;
import jinngine.physics.Body;
import jinngine.physics.DefaultScene;
import jinngine.physics.Scene;
import jinngine.physics.constraint.Constraint;
import jinngine.physics.constraint.contact.ContactConstraint;
import jinngine.physics.constraint.contact.ContactConstraintCreator;
import jinngine.physics.constraint.contact.ContactConstraintManager;
import jinngine.physics.constraint.contact.FrictionalContactConstraint;
import jinngine.util.ComponentGraph;
import jinngine.util.Pair;

public class DefaultContactConstraintManager
implements ContactConstraintManager {
    private final List<ContactConstraintManager.Handler> handlers = new ArrayList<ContactConstraintManager.Handler>();
    private final BroadphaseCollisionDetection broadphase;
    private final BroadphaseCollisionDetection.Handler handler;
    private final List<ContactGeneratorClassifier> geometryClassifiers = new ArrayList<ContactGeneratorClassifier>();
    private final List<ContactConstraintCreator> contactConstraintCreators = new ArrayList<ContactConstraintCreator>();
    private final Map<Pair<Body>, ContactConstraint> contactConstraints = new HashMap<Pair<Body>, ContactConstraint>();
    private final Map<Pair<Geometry>, ContactGenerator> contactGenerators = new HashMap<Pair<Geometry>, ContactGenerator>();
    private final ComponentGraph<Body, Constraint, DefaultScene.ConstraintGroup> constraintGraph;
    private final ContactConstraintCreator defaultcreator = new ContactConstraintCreator(){

        @Override
        public final ContactConstraint createContactConstraint(Body b1, Body b2, ContactGenerator g) {
            return new FrictionalContactConstraint(b1, b2, g);
        }

        @Override
        public void removeContactConstraint(ContactConstraint constraint) {
        }
    };

    public DefaultContactConstraintManager(BroadphaseCollisionDetection broadphase, ComponentGraph<Body, Constraint, DefaultScene.ConstraintGroup> constraintgraph) {
        this.broadphase = broadphase;
        this.constraintGraph = constraintgraph;
        this.handler = new BroadphaseCollisionDetection.Handler(){

            @Override
            public final void overlap(Pair<Geometry> inputpair) {
                Pair<Geometry> geometrypair;
                Pair<Body> bodypair;
                Body b;
                Body a = inputpair.getFirst().getBody();
                if (a == (b = inputpair.getSecond().getBody())) {
                    return;
                }
                if (a == null || b == null) {
                    return;
                }
                if (a.isFixed() && b.isFixed()) {
                    return;
                }
                if (a.hashCode() > b.hashCode()) {
                    bodypair = new Pair<Body>(a, b);
                    geometrypair = new Pair<Geometry>(inputpair.getFirst(), inputpair.getSecond());
                } else {
                    bodypair = new Pair<Body>(b, a);
                    geometrypair = new Pair<Geometry>(inputpair.getSecond(), inputpair.getFirst());
                }
                ContactConstraint contactConstraint = null;
                if (DefaultContactConstraintManager.this.contactConstraints.containsKey(bodypair)) {
                    contactConstraint = (ContactConstraint)DefaultContactConstraintManager.this.contactConstraints.get(bodypair);
                    ContactGenerator generator = DefaultContactConstraintManager.this.getContactGenerator(geometrypair);
                    DefaultContactConstraintManager.this.contactGenerators.put(geometrypair, generator);
                    contactConstraint.addGenerator(generator);
                } else if (DefaultContactConstraintManager.this.constraintGraph.getEdge(bodypair) == null) {
                    ContactConstraintCreator c;
                    ContactGenerator generator = DefaultContactConstraintManager.this.getContactGenerator(geometrypair);
                    Iterator i$ = DefaultContactConstraintManager.this.contactConstraintCreators.iterator();
                    while (i$.hasNext() && (contactConstraint = (c = (ContactConstraintCreator)i$.next()).createContactConstraint(bodypair.getFirst(), bodypair.getSecond(), generator)) == null) {
                    }
                    if (contactConstraint == null) {
                        contactConstraint = DefaultContactConstraintManager.this.defaultcreator.createContactConstraint(bodypair.getFirst(), bodypair.getSecond(), generator);
                    }
                    DefaultContactConstraintManager.this.contactConstraints.put(bodypair, contactConstraint);
                    DefaultContactConstraintManager.this.contactGenerators.put(geometrypair, generator);
                    DefaultContactConstraintManager.this.constraintGraph.addEdge(bodypair, contactConstraint);
                    for (ContactConstraintManager.Handler h : DefaultContactConstraintManager.this.handlers) {
                        h.contactConstraintCreated(bodypair, contactConstraint);
                    }
                }
            }

            @Override
            public final void separation(Pair<Geometry> geometrypair) {
                Body a = geometrypair.getFirst().getBody();
                Body b = geometrypair.getSecond().getBody();
                Pair<Body> bodypair = new Pair<Body>(a, b);
                if (a == b) {
                    return;
                }
                if (a == null || b == null) {
                    return;
                }
                if (a.isFixed() && b.isFixed()) {
                    return;
                }
                if (DefaultContactConstraintManager.this.contactConstraints.containsKey(bodypair)) {
                    if (DefaultContactConstraintManager.this.contactGenerators.containsKey(geometrypair)) {
                        ContactConstraint constraint = (ContactConstraint)DefaultContactConstraintManager.this.contactConstraints.get(bodypair);
                        ContactGenerator cg = (ContactGenerator)DefaultContactConstraintManager.this.contactGenerators.get(geometrypair);
                        cg.remove();
                        constraint.removeGenerator(cg);
                        DefaultContactConstraintManager.this.contactGenerators.remove(geometrypair);
                        if (constraint.getNumberOfGenerators() < 1.0) {
                            DefaultContactConstraintManager.this.contactConstraints.remove(bodypair);
                            DefaultContactConstraintManager.this.constraintGraph.removeEdge(bodypair);
                            for (ContactConstraintManager.Handler h : DefaultContactConstraintManager.this.handlers) {
                                h.contactConstraintRemoved(bodypair, constraint);
                            }
                        }
                    } else {
                        System.out.println("missing contact generator");
                        System.exit(0);
                    }
                }
            }
        };
        broadphase.addHandler(this.handler);
        this.geometryClassifiers.add(new ContactGeneratorClassifier(){

            @Override
            public final ContactGenerator getGenerator(Geometry a, Geometry b) {
                if (a instanceof Sphere && b instanceof Sphere) {
                    return new SphereContactGenerator((Sphere)a, (Sphere)b);
                }
                return null;
            }
        });
        this.geometryClassifiers.add(new ContactGeneratorClassifier(){

            @Override
            public final ContactGenerator getGenerator(Geometry a, Geometry b) {
                if (a instanceof SupportMap3 && b instanceof Sphere) {
                    return new SupportMapSphereContactGenerator(a.getBody(), a, (SupportMap3)((Object)a), b.getBody(), (Sphere)b);
                }
                if (a instanceof Sphere && b instanceof SupportMap3) {
                    return new SupportMapSphereContactGenerator(a.getBody(), (Sphere)a, b.getBody(), b, (SupportMap3)((Object)b));
                }
                return null;
            }
        });
        this.geometryClassifiers.add(new ContactGeneratorClassifier(){

            @Override
            public final ContactGenerator getGenerator(Geometry a, Geometry b) {
                if (a instanceof SupportMap3 && b instanceof SupportMap3) {
                    return new SupportMapContactGenerator((SupportMap3)((Object)a), a, (SupportMap3)((Object)b), b);
                }
                return null;
            }
        });
    }

    public void removeBroadphaseHandler() {
        this.broadphase.removeHandler(this.handler);
    }

    public final void addContactConstraintCreator(ContactConstraintCreator c) {
        this.contactConstraintCreators.add(c);
    }

    public final void removeContactConstraintCreator(ContactConstraintCreator c) {
        this.contactConstraintCreators.remove(c);
    }

    private ContactGenerator getContactGenerator(Pair<Geometry> pair) {
        for (ContactGeneratorClassifier gc : this.geometryClassifiers) {
            ContactGenerator g = gc.getGenerator(pair.getFirst(), pair.getSecond());
            if (g == null) continue;
            return g;
        }
        return null;
    }

    @Override
    public void cleanup(Scene scene) {
    }

    @Override
    public void setup(Scene scene) {
    }

    @Override
    public void addHandler(ContactConstraintManager.Handler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void removeHandler(ContactConstraintManager.Handler handler) {
        this.handlers.remove(handler);
    }
}

