/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.force;

import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.force.Force;

public class SpringForce
implements Force {
    private final Body a;
    private final Body b;
    private final Vector3 pa;
    private final Vector3 pb;
    private double equilibrium;
    private final double force;
    private final double damper;

    public SpringForce(Body a, Vector3 pa, Body b, Vector3 pb) {
        this.a = a;
        this.b = b;
        this.pa = pa.copy();
        this.pb = pb.copy();
        this.force = 10.0;
        this.damper = 1.0;
        Vector3 paw = a.toWorld(pa);
        Vector3 pbw = b.toWorld(pb);
        Vector3 x = paw.minus(pbw);
        this.equilibrium = x.norm();
    }

    public SpringForce(Body a, Vector3 pa, Body b, Vector3 pb, double force, double damper) {
        this.a = a;
        this.b = b;
        this.pa = pa.copy();
        this.pb = pb.copy();
        this.force = force;
        this.damper = damper;
        Vector3 paw = a.toWorld(pa);
        Vector3 pbw = b.toWorld(pb);
        Vector3 x = paw.minus(pbw);
        this.equilibrium = x.norm();
    }

    public SpringForce(Body a, Vector3 pa, Body b, Vector3 pb, double equilibrilium) {
        this.a = a;
        this.b = b;
        this.pa = pa;
        this.pb = pb;
        this.equilibrium = equilibrilium;
        this.force = 10.0;
        this.damper = 1.0;
    }

    @Override
    public void apply(double dt) {
        Vector3 pra = this.a.toWorldNoTranslation(this.pa);
        Vector3 prb = this.b.toWorldNoTranslation(this.pb);
        Vector3 paw = pra.add(this.a.state.position);
        Vector3 pbw = prb.add(this.b.state.position);
        Vector3 x = pbw.minus(paw);
        Vector3 upa = this.a.state.velocity.add(this.a.state.omega.cross(pra));
        Vector3 upb = this.b.state.velocity.add(this.b.state.omega.cross(prb));
        Vector3 n = x.abs().lessThan(Vector3.epsilon) ? (x = Vector3.zero) : x.normalize();
        if (x.norm() > 1.0) {
            x.assign(x.normalize().multiply(1.0));
        }
        double upax = n.dot(upa);
        double upbx = n.dot(upb);
        Vector3 Fspring = x.minus(n.multiply(this.equilibrium)).multiply(this.force);
        Vector3 Fdamper = n.multiply((-upax + upbx) * this.damper);
        Vector3 Ftotal = Fspring.add(Fdamper);
        this.a.applyForce(pra, Ftotal.multiply(1.0), dt);
        this.b.applyForce(prb, Ftotal.multiply(-1.0), dt);
    }
}

