/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.items.weapons;

import com.google.common.collect.Multimap;
import georgetsak.opcraft.main.CommonProxy;
import georgetsak.opcraft.misc.OPSoundEvent;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemClima
extends Item {
    private final float attackDamage;
    int type = 0;
    boolean completed;
    boolean killed = false;

    public ItemClima(int durability, float attackDamage, int type, boolean completed) {
        this.type = type;
        this.field_77777_bU = 1;
        this.func_77656_e(durability);
        this.attackDamage = attackDamage;
        this.completed = completed;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.completed) {
            if (player.func_70093_af()) {
                switch (this.type) {
                    case 1: {
                        ItemStack stack2 = new ItemStack(CommonProxy.ItemClimaCompletedFire, 1);
                        stack2.func_77972_a(this.getDamage(stack), (EntityLivingBase)player);
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack2);
                        return EnumActionResult.SUCCESS;
                    }
                    case 2: {
                        ItemStack stack2 = new ItemStack(CommonProxy.ItemClimaCompletedThunder, 1);
                        stack2.func_77972_a(this.getDamage(stack), (EntityLivingBase)player);
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack2);
                        return EnumActionResult.SUCCESS;
                    }
                    case 3: {
                        ItemStack stack2 = new ItemStack(CommonProxy.ItemClimaCompletedWater, 1);
                        stack2.func_77972_a(this.getDamage(stack), (EntityLivingBase)player);
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack2);
                        return EnumActionResult.SUCCESS;
                    }
                }
            } else {
                int i;
                double distance = 10.0;
                double x1 = player.field_70165_t - distance;
                double x2 = player.field_70165_t + distance;
                double y1 = player.field_70163_u - distance;
                double y2 = player.field_70163_u + distance;
                double z1 = player.field_70161_v - distance;
                double z2 = player.field_70161_v + distance;
                List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
                List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
                PotionEffect pe = null;
                boolean fire = false;
                boolean thunder = false;
                this.killed = false;
                switch (this.type) {
                    case 0: {
                        return EnumActionResult.FAIL;
                    }
                    case 1: {
                        world.func_184133_a(player, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), OPSoundEvent.clima_ice, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        pe = new PotionEffect(MobEffects.field_76421_d, 200, 5);
                        this.freezeBlocks(world, player, 5);
                        break;
                    }
                    case 2: {
                        fire = true;
                        world.func_184133_a(player, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), OPSoundEvent.clima_fire, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        thunder = true;
                    }
                }
                if (!entities.isEmpty()) {
                    for (i = 0; i < entities.size(); ++i) {
                        if (!(entities.get(i) instanceof EntityLiving)) continue;
                        EntityLivingBase entitylivingbase = (EntityLivingBase)entities.get(i);
                        this.killed = true;
                        if (!fire && !thunder) {
                            entitylivingbase.func_70690_d(pe);
                            continue;
                        }
                        if (fire) {
                            entitylivingbase.func_70015_d(5);
                            continue;
                        }
                        if (!thunder) continue;
                        world.func_72838_d((Entity)new EntityLightningBolt(world, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, false));
                    }
                }
                if (!players.isEmpty()) {
                    for (i = 0; i < players.size(); ++i) {
                        if (!(players.get(i) instanceof EntityPlayer)) continue;
                        EntityPlayer players2 = (EntityPlayer)players.get(i);
                        if (players2.field_71071_by.func_70448_g() == null) {
                            this.killed = true;
                            if (!fire && !thunder) {
                                players2.func_70690_d(pe);
                                continue;
                            }
                            if (fire) {
                                players2.func_70015_d(5);
                                continue;
                            }
                            if (!thunder) continue;
                            world.func_72838_d((Entity)new EntityLightningBolt(world, players2.field_70165_t, players2.field_70163_u, players2.field_70161_v, false));
                            continue;
                        }
                        if (players2.field_71071_by.func_70448_g().func_77973_b() == this) continue;
                        this.killed = true;
                        if (!fire && !thunder) {
                            players2.func_70690_d(pe);
                            continue;
                        }
                        if (fire) {
                            players2.func_70015_d(5);
                            continue;
                        }
                        if (!thunder) continue;
                        world.func_72838_d((Entity)new EntityLightningBolt(world, players2.field_70165_t, players2.field_70163_u, players2.field_70161_v, false));
                    }
                }
            }
        }
        if (this.killed) {
            if (this.type == 3) {
                stack.func_77972_a(10, (EntityLivingBase)player);
            } else {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        player.func_184811_cZ().func_185145_a((Item)this, 20);
        return EnumActionResult.SUCCESS;
    }

    private void freezeBlocks(World world, EntityPlayer player, int i) {
        int invertedI = -i;
        BlockPos center = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        for (int x = invertedI; x <= i; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = invertedI; z <= i; ++z) {
                    if (world.func_180495_p(center.func_177982_a(x, y, z)).func_177230_c() != Blocks.field_150355_j) continue;
                    this.killed = true;
                    world.func_175656_a(center.func_177982_a(x, y, z), CommonProxy.TemporaryIce.func_176223_P());
                }
            }
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }
}

