/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.main;

import georgetsak.opcraft.entities.marines.EntityMarine;
import georgetsak.opcraft.entities.other.bandit.EntityBandit;
import georgetsak.opcraft.main.OPCraft;
import georgetsak.opcraft.main.Registry.OPItems;
import georgetsak.opcraft.misc.capabilities.bounty.BountyCapProvider;
import georgetsak.opcraft.misc.capabilities.bounty.IBountyCap;
import georgetsak.opcraft.misc.capabilities.devilfruits.DevilFruitsCapProvider;
import georgetsak.opcraft.misc.capabilities.devilfruits.IDevilFruitsCap;
import georgetsak.opcraft.misc.capabilities.stats.normal.IStatsNormalCap;
import georgetsak.opcraft.misc.capabilities.stats.normal.StatsNormalCapProvider;
import georgetsak.opcraft.network.PacketDispatcher;
import georgetsak.opcraft.network.packets.ConfigPacket;
import georgetsak.opcraft.network.packets.DevilFruitCapPacket;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class OPServerEventHooks {
    public static final String TAG_PLAYER_HAS_MANUAL = "onepiececraft.hasBook";

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player != null) {
            System.out.println("Player " + event.player.func_145748_c_() + " joined. Sending Config.");
            PacketDispatcher.sendTo(new ConfigPacket(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn2(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound data;
        NBTTagCompound playerData = event.player.getEntityData();
        if (!playerData.func_74764_b("PlayerPersisted") && !(data = playerData.func_74775_l("PlayerPersisted")).func_74767_n(TAG_PLAYER_HAS_MANUAL)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)new ItemStack(OPItems.ItemManualBook, 1));
            data.func_74757_a(TAG_PLAYER_HAS_MANUAL, true);
            playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
        }
    }

    @SubscribeEvent
    public void setAttackTarget(LivingSetAttackTargetEvent event) {
        EntityPlayer ep;
        if (event.getEntity() instanceof EntityMarine && event.getTarget() instanceof EntityPlayer && !((IBountyCap)(ep = (EntityPlayer)event.getTarget()).getCapability(BountyCapProvider.B_CAP, null)).isWanted()) {
            ((EntityLiving)event.getEntity()).func_70624_b(null);
        }
        if (event.getEntity() instanceof EntityBandit && event.getTarget() instanceof EntityPlayer && ((IBountyCap)(ep = (EntityPlayer)event.getTarget()).getCapability(BountyCapProvider.B_CAP, null)).getBounty() > 5000) {
            ((EntityLiving)event.getEntity()).func_70624_b(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerHurt(LivingHurtEvent event) {
        EntityPlayer ep;
        IDevilFruitsCap df;
        EntityLivingBase en = event.getEntityLiving();
        if (en instanceof EntityPlayer && ((EntityPlayer)en).func_110143_aJ() - event.getAmount() <= 0.0f && (df = (IDevilFruitsCap)(ep = (EntityPlayer)en).getCapability(DevilFruitsCapProvider.DF_CAP, null)).getPower() == 9) {
            ep.func_146105_b((ITextComponent)new TextComponentString("You were revived by using Yomi Yomi no mi devil fruit power!"));
            df.setPower(0);
            PacketDispatcher.sendTo(new DevilFruitCapPacket(df), (EntityPlayerMP)ep);
            ep.func_70691_i(20.0f);
            Random r = new Random();
            BlockPos spawnpoint = ep.field_70170_p.func_175694_M();
            double x = (double)spawnpoint.func_177958_n() + (double)(r.nextInt(2000) - 1000);
            double z = (double)spawnpoint.func_177952_p() + (double)(r.nextInt(2000) - 1000);
            double y = ep.field_70170_p.func_175672_r(new BlockPos(x, 0.0, z)).func_177956_o();
            ep.func_184595_k(x, y, z);
            event.setCanceled(true);
        }
        if (en instanceof EntityPlayer && event.getSource().equals(DamageSource.field_180137_b) && (df = (IDevilFruitsCap)(ep = (EntityPlayer)en).getCapability(DevilFruitsCapProvider.DF_CAP, null)).getPower() == 10) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getSource().field_76373_n.equals("outOfWorld")) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            event.setAmount(event.getAmount() - event.getAmount() * (float)((IStatsNormalCap)player.getCapability(StatsNormalCapProvider.SN_CAP, null)).getDefenceLevel() * 5.0f / 100.0f);
        }
    }

    @SubscribeEvent
    public void lootTable(LootTableLoadEvent event) {
        LootPool main;
        boolean flag1 = event.getName() == LootTableList.field_186424_f;
        boolean flag2 = event.getName() == LootTableList.field_186429_k;
        boolean flag3 = event.getName() == LootTableList.field_186430_l;
        boolean flag4 = event.getName() == LootTableList.field_186422_d;
        boolean flag = flag1 || flag2 || flag3 || flag4;
        int prob = 15;
        if (flag && (main = event.getTable().getPool("main")) != null && OPCraft.config.enableDevilFruitsSpawning) {
            if (!OPCraft.config.completelyDisableDevilFruitGomu && OPCraft.config.enableDevilFruitGomuSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitLuffy, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPluffyLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitMera && OPCraft.config.enableDevilFruitMeraSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitAce, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPaceLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitNoro && OPCraft.config.enableDevilFruitNoroSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitSlow, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPslowLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitSuke && OPCraft.config.enableDevilFruitSukeSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitClear, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPclearLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitUshi && OPCraft.config.enableDevilFruitUshiSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitGiraffe, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPgiraffeLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitOpe && OPCraft.config.enableDevilFruitOpeSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitLaw, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPlawLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitHie && OPCraft.config.enableDevilFruitHieSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitIce, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPiceLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitNikyu && OPCraft.config.enableDevilFruitNikyuSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitPaw, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPpawLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitYomi && OPCraft.config.enableDevilFruitYomiSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitRevive, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPreviveLoot"));
            }
            if (!OPCraft.config.completelyDisableDevilFruitGoro && OPCraft.config.enableDevilFruitGoroSpawning) {
                main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitThunder, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPthunderLoot"));
            }
            main.addEntry((LootEntry)new LootEntryItem(OPItems.ItemDevilFruitPowerRemover, prob, 1, new LootFunction[0], new LootCondition[0], "onepiececraft:OPdevilFruitRemoverLoot"));
        }
    }
}

