/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.misc.capabilities;

import georgetsak.opcraft.misc.capabilities.bounty.BountyCap;
import georgetsak.opcraft.misc.capabilities.bounty.BountyCapProvider;
import georgetsak.opcraft.misc.capabilities.bounty.IBountyCap;
import georgetsak.opcraft.misc.capabilities.devilfruits.DevilFruitsCap;
import georgetsak.opcraft.misc.capabilities.devilfruits.DevilFruitsCapProvider;
import georgetsak.opcraft.misc.capabilities.devilfruits.IDevilFruitsCap;
import georgetsak.opcraft.misc.capabilities.stats.normal.IStatsNormalCap;
import georgetsak.opcraft.misc.capabilities.stats.normal.StatsNormalCap;
import georgetsak.opcraft.misc.capabilities.stats.normal.StatsNormalCapProvider;
import georgetsak.opcraft.network.PacketDispatcher;
import georgetsak.opcraft.network.packets.BountyPacket;
import georgetsak.opcraft.network.packets.DevilFruitCapPacket;
import georgetsak.opcraft.network.packets.StatsNormalPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CapabilityHandler {
    public static final ResourceLocation DF_CAP = new ResourceLocation("onepiececraft", "devilfruits");
    public static final ResourceLocation B_CAP = new ResourceLocation("onepiececraft", "bounty");
    public static final ResourceLocation SN_CAP = new ResourceLocation("onepiececraft", "normalstats");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent.Entity event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(DF_CAP, (ICapabilityProvider)new DevilFruitsCapProvider());
        event.addCapability(B_CAP, (ICapabilityProvider)new BountyCapProvider());
        event.addCapability(SN_CAP, (ICapabilityProvider)new StatsNormalCapProvider());
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        PacketDispatcher.sendTo(new DevilFruitCapPacket(DevilFruitsCap.get(player)), (EntityPlayerMP)player);
        PacketDispatcher.sendTo(new BountyPacket(BountyCap.get(player)), (EntityPlayerMP)player);
        PacketDispatcher.sendTo(new StatsNormalPacket(StatsNormalCap.get(player)), (EntityPlayerMP)player);
    }

    @SubscribeEvent
    public void onPlayerSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.field_70170_p.field_72995_K) {
                IDevilFruitsCap df = DevilFruitsCap.get(player);
                IBountyCap b = BountyCap.get(player);
                IStatsNormalCap sn = StatsNormalCap.get(player);
                PacketDispatcher.sendTo(new DevilFruitCapPacket(df), (EntityPlayerMP)player);
                PacketDispatcher.sendTo(new BountyPacket(b), (EntityPlayerMP)player);
                PacketDispatcher.sendTo(new StatsNormalPacket(sn), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IDevilFruitsCap df = DevilFruitsCap.get(player);
        IDevilFruitsCap old_df = DevilFruitsCap.get(event.getOriginal());
        df.copy(old_df, player);
        IBountyCap b = BountyCap.get(player);
        IBountyCap old_b = BountyCap.get(event.getOriginal());
        b.copy(old_b, player);
        IStatsNormalCap sn = StatsNormalCap.get(player);
        IStatsNormalCap old_sn = StatsNormalCap.get(event.getOriginal());
        sn.copy(old_sn, player);
    }
}

