/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.misc.generators;

import georgetsak.opcraft.main.OPCraft;
import georgetsak.opcraft.main.Registry.OPBlocks;
import georgetsak.opcraft.misc.generators.terrain.WorldGenAdamTree;
import georgetsak.opcraft.misc.generators.terrain.WorldGenCherryTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OPIWorldGenerator
implements IWorldGenerator {
    private void generateNether(World world, Random rand, int blockX, int blockZ) {
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        WorldGenMinable worldGenMinable;
        int x;
        WorldGenCherryTree worldGenCherryTree = new WorldGenCherryTree();
        WorldGenAdamTree worldGenAdamTree = new WorldGenAdamTree();
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(blockX, 64, blockZ));
        if (biome == Biomes.field_76772_c && world.func_175624_G() != WorldType.field_77138_c) {
            int MIN = 0;
            int MAX = 2;
            int numBushes = MIN + rand.nextInt(MAX - MIN);
            for (int i = 0; i < numBushes; ++i) {
                int randX = blockX + rand.nextInt(16);
                int randZ = blockZ + rand.nextInt(16);
                if (rand.nextInt(1000) == 0) {
                    worldGenAdamTree.func_180709_b(world, rand, new BlockPos(randX, OPIWorldGenerator.getGroundFromAbove(world, randX + 2, randZ), randZ));
                    continue;
                }
                worldGenCherryTree.func_180709_b(world, rand, new BlockPos(randX, OPIWorldGenerator.getGroundFromAbove(world, randX, randZ), randZ));
            }
        }
        if (biome == Biomes.field_76772_c && world.func_175624_G() != WorldType.field_77138_c && OPCraft.config.enableMorganFortress) {
            int randX = blockX + rand.nextInt(16);
            int randZ = blockZ + rand.nextInt(16);
            if (rand.nextInt(OPCraft.config.morganFortressSpawnChance) == 0) {
                Template morgan_fortress_stage1 = this.getTemplate("morgan_fortress_stage1", world);
                Template morgan_fortress_stage2 = this.getTemplate("morgan_fortress_stage2", world);
                Rotation rot = this.randomRot(rand);
                PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(true).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);
                PlacementSettings placementsettingsTorch = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);
                int finalY = OPIWorldGenerator.getAverageHeight(world, randX, randZ - 1, 109, false) + 1;
                if (morgan_fortress_stage1 != null && morgan_fortress_stage2 != null) {
                    this.clear(world, randX, finalY, randZ, 102, 42, 52, rot);
                    System.out.println("Spawning fortress at " + randX + " // " + randZ);
                    morgan_fortress_stage1.func_186253_b(world, new BlockPos(randX, finalY, randZ), placementsettings);
                    morgan_fortress_stage2.func_186253_b(world, new BlockPos(randX, finalY, randZ), placementsettingsTorch);
                }
            }
        }
        if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76781_i || biome == Biomes.field_76777_m || biome == Biomes.field_76776_l) {
            int kairosekiMIN = 1;
            int kairosekiMAX = 3;
            int kairoseki = kairosekiMIN + rand.nextInt(kairosekiMAX - kairosekiMIN);
            for (x = 0; x < kairoseki; ++x) {
                int randX = blockX + rand.nextInt(16);
                int randZ = blockZ + rand.nextInt(16);
                int randY = rand.nextInt(15) + 5;
                worldGenMinable = new WorldGenMinable(OPBlocks.BlockKairosekiStone.func_176223_P(), 3);
                worldGenMinable.func_180709_b(world, rand, new BlockPos(randX, randY, randZ));
            }
        }
        int steelMIN = 2;
        int steelMAX = 5;
        int steel = steelMIN + rand.nextInt(steelMAX - steelMIN);
        for (x = 0; x < steel; ++x) {
            int randX = blockX + rand.nextInt(16);
            int randZ = blockZ + rand.nextInt(16);
            int randY = rand.nextInt(40) + 5;
            worldGenMinable = rand.nextInt(3) <= 1 ? new WorldGenMinable(OPBlocks.BlockSteelOre.func_176223_P(), 4) : new WorldGenMinable(OPBlocks.BlockDarkSteelOre.func_176223_P(), 3);
            worldGenMinable.func_180709_b(world, rand, new BlockPos(randX, randY, randZ));
        }
    }

    private void clear(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ, Rotation rot) {
        for (int i = 0; i <= sizeX; ++i) {
            for (int j = 0; j <= sizeY; ++j) {
                for (int k = 0; k <= sizeZ; ++k) {
                    world.func_175698_g(new BlockPos(x, y, z).func_177982_a(i, j, k));
                }
            }
        }
    }

    private void generateEnd(World world, Random rand, int blockX, int blockZ) {
    }

    private Template getTemplate(String fileName, World world) {
        WorldServer worldserver = (WorldServer)world;
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = worldserver.func_184163_y();
        return templatemanager.func_189942_b(minecraftserver, new ResourceLocation("onepiececraft", fileName));
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y;
        boolean foundGround = false;
        for (y = 255; !foundGround && y >= 0; --y) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150346_d || blockAt == Blocks.field_150349_c;
        }
        return y;
    }

    public static int getAverageHeight(World world, int x, int z, int radius, boolean lowestBlockMode) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int i = x - radius; i < x + radius; ++i) {
            for (int k = z - radius; k < z + radius; ++k) {
                int y;
                boolean foundGround = false;
                for (y = 255; !foundGround && y >= 0; --y) {
                    Block blockAt = world.func_180495_p(new BlockPos(i, y, k)).func_177230_c();
                    foundGround = blockAt != Blocks.field_150350_a;
                }
                heights.add(y);
            }
        }
        int totalSum = 0;
        for (int i = 0; i < heights.size(); ++i) {
            totalSum += ((Integer)heights.get(i)).intValue();
        }
        if (lowestBlockMode) {
            Collections.sort(heights);
            return (Integer)heights.get(0);
        }
        return totalSum / (radius * 2 * radius * 2);
    }

    private Rotation randomRot(Random rand) {
        int i = rand.nextInt(4);
        switch (i) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, random, blockX, blockZ);
                break;
            }
            case 0: {
                this.generateOverworld(world, random, blockX, blockZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, blockX, blockZ);
            }
        }
    }
}

