/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.opcraft.network;

import georgetsak.opcraft.network.AbstractMessage;
import georgetsak.opcraft.network.packets.BountyPacket;
import georgetsak.opcraft.network.packets.ConfigPacket;
import georgetsak.opcraft.network.packets.DevilFruitCapPacket;
import georgetsak.opcraft.network.packets.IceCageEntityServerPacket;
import georgetsak.opcraft.network.packets.OPMessage;
import georgetsak.opcraft.network.packets.RayTracePacket;
import georgetsak.opcraft.network.packets.StatsNormalPacket;
import georgetsak.opcraft.network.packets.StatsNormalServerPacket;
import georgetsak.opcraft.network.packets.UpdateXPLevelsPacket;
import georgetsak.opcraft.network.packets.UpdateXPLevelsServerPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("onepiececraft");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(OPMessage.class);
        PacketDispatcher.registerMessage(RayTracePacket.class);
        PacketDispatcher.registerMessage(ConfigPacket.class);
        PacketDispatcher.registerMessage(DevilFruitCapPacket.class);
        PacketDispatcher.registerMessage(BountyPacket.class);
        PacketDispatcher.registerMessage(StatsNormalPacket.class);
        PacketDispatcher.registerMessage(StatsNormalServerPacket.class);
        PacketDispatcher.registerMessage(UpdateXPLevelsServerPacket.class);
        PacketDispatcher.registerMessage(UpdateXPLevelsPacket.class);
        PacketDispatcher.registerMessage(IceCageEntityServerPacket.class);
    }

    private static final <T extends AbstractMessage<T>> void registerMessage(Class<T> clazz) {
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.CLIENT);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        } else {
            dispatcher.registerMessage(clazz, clazz, (int)packetId, Side.CLIENT);
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        }
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

