/*
 * Decompiled with CFR 0.152.
 */
package JaideepSinghHeer.Minecraft.mod;

import JaideepSinghHeer.Minecraft.mod.PropertyManagerClient;
import JaideepSinghHeer.Minecraft.mod.SPLANtransformerPort;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
@IFMLLoadingPlugin.SortingIndex(value=1001)
public class ServerPropertiesLAN
extends DummyModContainer
implements IFMLLoadingPlugin {
    public int port = 0;
    private static boolean whiteListFirstRun;
    private static boolean firstRun;
    private static IntegratedServer server;
    public static final String MODID = "splan";
    public static final String MODNAME = "Server Properties for LAN";
    public static final String VERSION = "2.65-1.7.10";
    public static final String UPDATEURL = "https://raw.githubusercontent.com/jaideepheer/MinecraftForge-Mods-ServerPropertiesLAN/master/src/main/resources/update.json";
    private PropertyManagerClient ServerProperties = null;
    private static final Logger LOGGER;
    public static ServerPropertiesLAN instance;

    public ServerPropertiesLAN() {
        super(new ModMetadata());
        whiteListFirstRun = false;
        System.out.println("-=-=-=-=-=-=-=ServerPropertiesLAN-Constructed=-=-=-=-=-=-=-");
        instance = this;
        ModMetadata md = this.getMetadata();
        md.autogenerated = false;
        md.useDependencyInformation = false;
        md.modId = MODID;
        md.version = VERSION;
        md.name = MODNAME;
        md.authorList = Lists.newArrayList((Object[])new String[]{"Jaideep Singh Heer"});
        md.url = "https://minecraft.curseforge.com/projects/server-properties-for-lan";
        md.description = "MeoW.!\nGet the latest version at: " + md.updateUrl;
        md.credits = "by Jaideep Singh Heer";
        md.logoFile = "logo.png";
        md.screenshots = new String[]{"scr1.jpg", "Untitled.jpg", "logo2.png"};
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void onServerStarting(FMLServerStartingEvent event) {
        System.out.println("========================>> Server Starting !");
        String worldrootdir = DimensionManager.getCurrentSaveRootDirectory() + File.separator;
        File local = new File(worldrootdir + "server.properties");
        File global = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "config" + File.separator + "serverGlobalConfig.properties");
        if (!global.exists()) {
            firstRun = true;
            this.ServerProperties = new PropertyManagerClient(global);
        } else if (local.exists()) {
            this.ServerProperties = new PropertyManagerClient(local);
            if (!this.ServerProperties.getBooleanProperty("overrideGlobalDefaults", true)) {
                this.ServerProperties.setPropertiesFile(global);
                LOGGER.info("Using Global Server Properties !");
            }
        } else {
            try {
                Files.copy((File)global, (File)local);
                this.ServerProperties = new PropertyManagerClient(local);
                this.ServerProperties.comment = this.ServerProperties.comment + System.getProperty("line.separator") + "overrideGlobalDefaults :" + System.getProperty("line.separator") + "\tspecify weather to use this file to override the global settings in the file \"" + global.getAbsolutePath() + "\"";
                this.ServerProperties.getBooleanProperty("overrideGlobalDefaults", false);
                this.ServerProperties.saveProperties();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARN, "Could not create local server config file. Using the global one.");
                e.printStackTrace();
                this.ServerProperties = new PropertyManagerClient(global);
            }
        }
        LOGGER.info("Using file : " + (this.ServerProperties.getBooleanProperty("overrideGlobalDefaults", true) ? local.getPath() : global.getPath()));
        server = (IntegratedServer)event.getServer();
        this.ServerProperties.comment = "Minecraft Server Properties for LAN." + System.getProperty("line.separator") + "For default behaviour :-" + System.getProperty("line.separator") + "set max-view-distance=0" + System.getProperty("line.separator") + "set port=0" + System.getProperty("line.separator") + "You can also delete this(or any properties) file to get it regenerated with default values.";
        this.port = this.ServerProperties.getIntProperty("port", 0);
        server.func_71229_d(this.ServerProperties.getBooleanProperty("online-mode", true));
        server.func_71251_e(this.ServerProperties.getBooleanProperty("spawn-animals", true));
        server.func_71257_f(this.ServerProperties.getBooleanProperty("spawn-npcs", true));
        server.func_71188_g(this.ServerProperties.getBooleanProperty("pvp", true));
        server.func_71245_h(this.ServerProperties.getBooleanProperty("allow-flight", false));
        Field field = ReflectionHelper.findField(MinecraftServer.class, (String[])new String[]{"field_147141_M"});
        field.setAccessible(true);
        try {
            field.set(server, this.ServerProperties.getStringProperty("resource-pack", ""));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        server.func_71205_p(this.ServerProperties.getStringProperty("motd", "<! " + server.func_71214_G() + "'s " + server.func_71221_J() + " ON LAN !>"));
        server.func_143006_e(this.ServerProperties.getIntProperty("player-idle-timeout", 0));
        server.func_71191_d(this.ServerProperties.getIntProperty("max-build-height", 256));
        LOGGER.info("Server Data :- ");
        LOGGER.info("online-mode = " + server.func_71266_T());
        LOGGER.info("spawn-animals = " + server.func_71268_U());
        LOGGER.info("spawn-npcs = " + server.func_71220_V());
        LOGGER.info("pvp = " + server.func_71219_W());
        LOGGER.info("allow-flight = " + server.func_71231_X());
        LOGGER.info("player-idle-timeout = " + server.func_143007_ar());
        LOGGER.info("max-build-height = " + server.func_71207_Z());
        LOGGER.info("resource-pack = " + server.func_147133_T());
        LOGGER.info("motd = " + server.func_71273_Y());
        ServerConfigurationManager customPlayerList = server.func_71203_ab();
        try {
            Field field2 = ReflectionHelper.findField(ServerConfigurationManager.class, (String[])new String[]{"maxPlayers", "field_72405_c"});
            field2.setAccessible(true);
            field2.set(customPlayerList, this.ServerProperties.getIntProperty("max-players", 10));
            LOGGER.info("Max Players = " + customPlayerList.func_72352_l());
            Field dist = ReflectionHelper.findField(ServerConfigurationManager.class, (String[])new String[]{"viewDistance", "field_72402_d"});
            dist.setAccessible(true);
            int d = this.ServerProperties.getIntProperty("max-view-distance", 0);
            if (d > 0) {
                dist.set(customPlayerList, d);
                LOGGER.info("Max view distance = " + d);
            } else {
                LOGGER.info("max-view-distance is set <= 0. Using default view distance algorithm.");
            }
            if (this.ServerProperties.getBooleanProperty("white-list", false)) {
                LOGGER.warn("=====>>WARNING whitelisting enabled...! Make sure at least one user entry is in the whitelist.json file !");
                File whitelistjson = new File(worldrootdir + "whitelist.json");
                UserListWhitelist whitelist = new UserListWhitelist(whitelistjson);
                if (!whitelistjson.exists()) {
                    whitelistjson.createNewFile();
                    whitelist.func_152678_f();
                    whiteListFirstRun = true;
                    field2 = ReflectionHelper.findField(ServerConfigurationManager.class, (String[])new String[]{"whiteListedPlayers", "field_72411_j"});
                    field2.setAccessible(true);
                    field2.set(customPlayerList, whitelist);
                } else {
                    customPlayerList.func_72371_a(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (firstRun) {
            try {
                Files.copy((File)global, (File)local);
                this.ServerProperties.setPropertiesFile(local);
                this.ServerProperties.comment = this.ServerProperties.comment + System.getProperty("line.separator") + "overrideGlobalDefaults :" + System.getProperty("line.separator") + "\tspecify weather to use this file to override the global settings in the file \"" + global.getAbsolutePath() + "\"";
                this.ServerProperties.getBooleanProperty("overrideGlobalDefaults", false);
                this.ServerProperties.saveProperties();
            }
            catch (IOException e) {
                LOGGER.error("Oops..! Couldn't copy to local server config file. Please manually copy the global server config file to your world save directory.");
                e.printStackTrace();
            }
        }
    }

    public String[] getASMTransformerClass() {
        return new String[]{SPLANtransformerPort.class.getCanonicalName()};
    }

    public String getModContainerClass() {
        return ServerPropertiesLAN.class.getCanonicalName();
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public Object getMod() {
        return instance;
    }

    public URL getUpdateUrl() {
        try {
            return new URL(UPDATEURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

